# Agent Forwarding

Adding and removing keys to the agent:
```
waja at Brotschneidemaschine in ~
$ eval "$(ssh-agent -s)"
Agent pid 7715

waja at Brotschneidemaschine in ~
$ ssh-add -L
The agent has no identities.

waja at Brotschneidemaschine in ~
$ ssh-add ~/.ssh/id_rsa
Identity added: /Users/waja/.ssh/id_rsa (waja@Brotschneidemaschine.local)

waja at Brotschneidemaschine in ~
$ ssh-add -L
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQCfovU+pdwsO4ubyG8kldmtFwVcfNIbJX8Qvi+4rWKmkcEx7xdz27o+CrCXyu3eSbw8q/BVNZImwbs3C4dCBZ+o7ZtHmJGYzyrIOkY1AD1kdf0tbH3boEqoL46xOx8zGIUWCcuJd+bzMw/ub/5Qf+yW6a00h4szFiREyM6k2y+0gF21ewoSKPZp+XTFFXfOoGAllJ1rhQq+PScUHHu81Ft9bl18e0SWKRJd/EOiI+2/GAb/jtYo0lxyIk1GrmZDA80Tew7Mv636zWfXUaL1Tr4Y8Wxmeetr97MLcVcY9hMZmQlcmurDqeIJdWn1IAr8IRieLJZPiMjt09LZ2EAd/TmI2lbfy3c+013qmc4YoOhXDlRgoS5qeQr/zupP1/0ATzG37pGtkomO1zz9WBafFy5ewzIU1YUArV+/PNWbVdrnIEOKmHF/YM/ZCA5JwFp7M/8FOHZrM6KvCwcnmtHOzU+0y7eHYejUHTBOIrk9/SfP37IFEELaNrEJdDokQBXpT38= waja@Brotschneidemaschine.local

waja at Brotschneidemaschine in ~
$ tail -2 .ssh/config 
Host *
  ForwardAgent yes

waja at Brotschneidemaschine in ~
$ ssh-add -d ~/.ssh/id_rsa
Identity removed: /Users/waja/.ssh/id_rsa RSA (waja@Brotschneidemaschine.local)
```
Identities are not permanent, maybe use something like `echo 'AddKeysToAgent  yes' >> ~/.ssh/config`.
```
waja in 🌐 jumphost in ~
✦ ❯ kill -9 7715

waja in 🌐 jumphost in ~
✦ ❯ ssh-add -L
Error connecting to agent: Connection refused

waja in 🌐 jumphost in ~
✦ ❯ eval "$(ssh-agent -s)"
Agent pid 7795

waja in 🌐 jumphost in ~
✦ ❯ ssh-add -L
The agent has no identities.
```

You can [start](https://unix.stackexchange.com/a/390631) `ssh-agent` even via `systemd`.

## SSH Agent forwarding is nice but...

[You should only add servers you trust and that you intend to use with agent forwarding.](https://docs.github.com/en/developers/overview/using-ssh-agent-forwarding)
[Why using SSH agent-forwarding is a Bad Idea](https://medium.com/kernel-space/why-using-ssh-agent-forwarding-is-a-bad-idea-6cbdff31bbee)

# SSH ProxyCommand / ProxyJump

```
~ via ☕ via  
✦ ❯ tail -7 .ssh/config 
Host 192.168.66.*
  # https://www.cyberciti.biz/faq/linux-unix-ssh-proxycommand-passing-through-one-host-gateway-server/
  # https://goteleport.com/blog/ssh-proxyjump-ssh-proxycommand/
  # https://en.wikibooks.org/wiki/OpenSSH/Cookbook/Proxies_and_Jump_Hosts
  #ProxyJump user1@10.42.5.6:22
  #ProxyCommand ssh -q -W %h:%p user1@10.42.5.6
  ProxyCommand ssh -o 'ForwardAgent yes' 10.42.5.6 'ssh-add && nc %h %p'

```

ProxyJump can be chained by `ssh -J <host> -J <host>`.

# SSH Multiplexing

```
~ via ☕ via  
✦ ❯ tail -8 .ssh/config 
Host *
  # https://www.cyberciti.biz/faq/linux-unix-reuse-openssh-connection/
  # https://blog.scottlowe.org/2015/12/11/using-ssh-multiplexing/
  # https://en.wikibooks.org/wiki/OpenSSH/Cookbook/Multiplexing
  ControlPath ~/.ssh/controlmasters/%r@%h:%p
  ControlMaster auto
  ControlPersist yes
  MaxSessions 10
```

# [SSHFS](https://de.wikipedia.org/wiki/SSHFS)

```
sshfs [user@]hostname:[directory] mountpoint
```

[More](https://www.digitalocean.com/community/tutorials/how-to-use-sshfs-to-mount-remote-file-systems-over-ssh) information, [macFUSE and SSHFS](https://osxfuse.github.io/) and even [SSHFS-Win](https://osxfuse.github.io/). (mc is the amry knife)

# Port Forwarding / Tunneling

![SSH Tunnel](https://sslhowto.files.wordpress.com/2021/08/2922a-59b8e0_117ab19cfc3a42219ebb7ca9efa5c158mv2.png)

## Reverse Tunneling

![Reverse SSH Tunnel](https://sslhowto.files.wordpress.com/2021/08/86851-59b8e0_acd645df4dc647189417de5c5c57bfe5mv2.png)

https://www.maketecheasier.com/kill-unresponsive-ssh-session/