<style type="text/css">
  .reveal p {
    text-align: center;
  }
  .reveal ul {
    display: block;
  }
  .reveal ol {
    display: block;
  }
  .reveal blockquote {
    font-size: 70%;
  }
  .reveal-viewport {
    background: #d1cec6;
    background-color: #d1cec6;
  }
</style>

```text
 ____                                 __   ____ ____  _   _ 
|  _ \ _____      _____ _ __    ___  / _| / ___/ ___|| | | |
| |_) / _ \ \ /\ / / _ \ '__|  / _ \| |_  \___ \___ \| |_| |
|  __/ (_) \ V  V /  __/ |    | (_) |  _|  ___) |__) |  _  |
|_|   \___/ \_/\_/ \___|_|     \___/|_|   |____/____/|_| |_|
                                                            
```

---

## Target audience

- linux desktop CLI users
- linux admins

```text
  __________________________________________
 / This is the year of linux on the desktop \
|                                            |
|          ...Windows10 has WSL ;-)          |
 \                                          /
  ------------------------------------------
        \   ^__^
         \  (oo)\_______
            (__)\       )\/\
                ||----w |
                ||     ||
```

---

## [ssh-agent](https://www.ssh.com/academy/ssh/agent)

> The ssh-agent is a helper program that keeps track of user's identity keys and their passphrases. The agent can then use the keys to log into other servers without having the user type in a password or passphrase again. This implements a form of single sign-on (SSO).

---

## Agent Forwarding

```bash
$ eval "$(ssh-agent -s)"
Agent pid 7715
$ ssh-add -L
The agent has no identities.
$ ssh-add ~/.ssh/id_rsa
Identity added: /Users/waja/.ssh/id_rsa (waja@Brotschneidemaschine.local)
$ ssh-add -L
ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABgQCfovU+pdwsO4ubyG8kldmtFwVcfNIbJX8Qvi+4rWKmkcEx7xdz27o+CrCXyu3eSbw8q/BVNZImwbs3C4dCBZ+o7ZtHmJGYzyrIOkY1AD1kdf0tbH3boEqoL46xOx8zGIUWCcuJd+bzMw/ub/5Qf+yW6a00h4szFiREyM6k2y+0gF21ewoSKPZp+XTFFXfOoGAllJ1rhQq+PScUHHu81Ft9bl18e0SWKRJd/EOiI+2/GAb/jtYo0lxyIk1GrmZDA80Tew7Mv636zWfXUaL1Tr4Y8Wxmeetr97MLcVcY9hMZmQlcmurDqeIJdWn1IAr8IRieLJZPiMjt09LZ2EAd/TmI2lbfy3c+013qmc4YoOhXDlRgoS5qeQr/zupP1/0ATzG37pGtkomO1zz9WBafFy5ewzIU1YUArV+/PNWbVdrnIEOKmHF/YM/ZCA5JwFp7M/8FOHZrM6KvCwcnmtHOzU+0y7eHYejUHTBOIrk9/SfP37IFEELaNrEJdDokQBXpT38= waja@Brotschneidemaschine.local
$ tail -2 .ssh/config
Host *
  ForwardAgent yes
$ ssh-add -d ~/.ssh/id_rsa
Identity removed: /Users/waja/.ssh/id_rsa RSA (waja@Brotschneidemaschine.local)
```

<!--
show on jumphost / workstation
-->

---

## Identities are not permanent

```bash
$ kill -9 7715
$ ssh-add -L
$ eval "$(ssh-agent -s)"
Agent pid 7795
$ ssh-add -L
The agent has no identities.
```

<!--
show on jumphost / workstation
-->

- Maybe use something like
```bash
$ echo 'AddKeysToAgent yes' >> ~/.ssh/config
```
- You can [start](https://unix.stackexchange.com/a/390631) `ssh-agent` even via `systemd`.

---

## SSH Agent forwarding is nice but...

- [You should only add servers you trust and that you intend to use with agent forwarding.](https://docs.github.com/en/developers/overview/using-ssh-agent-forwarding)
- [Why using SSH agent-forwarding is a Bad Idea](https://medium.com/kernel-space/why-using-ssh-agent-forwarding-is-a-bad-idea-6cbdff31bbee)

---

## SSH ProxyCommand / ProxyJump

```bash
$ tail -7 .ssh/config
Host 192.168.66.*
  # https://www.cyberciti.biz/faq/linux-unix-ssh-proxycommand-passing-through-one-host-gateway-server/
  # https://goteleport.com/blog/ssh-proxyjump-ssh-proxycommand/
  # https://en.wikibooks.org/wiki/OpenSSH/Cookbook/Proxies_and_Jump_Hosts
  #ProxyJump user1@10.42.5.6:22
  #ProxyCommand ssh -q -W %h:%p user1@10.42.5.6
  ProxyCommand ssh -o 'ForwardAgent yes' 10.42.5.6 'ssh-add && nc %h %p'

```

- ProxyJump can be chained by
```bash
$ ssh -J <host> -J <host>
```

---

## [SSHFS](https://de.wikipedia.org/wiki/SSHFS)

```bash
$ sshfs [user@]hostname:[directory] mountpoint
```

[More](https://www.digitalocean.com/community/tutorials/how-to-use-sshfs-to-mount-remote-file-systems-over-ssh) information, [macFUSE and SSHFS](https://osxfuse.github.io/) and even [SSHFS-Win](https://osxfuse.github.io/). (mc is the army knife)

---

## mc can do sftp and ssh

![mc](images/mc.png)

---

## Port Forwarding / Tunneling

![SSH Tunnel](https://sslhowto.files.wordpress.com/2021/08/2922a-59b8e0_117ab19cfc3a42219ebb7ca9efa5c158mv2.png)

<!--
ssh -L <localIP>:8000:<qnapIP>:8080 <localIP>
-->

---

### Reverse Tunneling

![Reverse SSH Tunnel](https://sslhowto.files.wordpress.com/2021/08/86851-59b8e0_acd645df4dc647189417de5c5c57bfe5mv2.png)

[Adding / Removing Tunnels within an established connection](https://en.wikibooks.org/wiki/OpenSSH/Cookbook/Tunnels#Adding_or_Removing_Tunnels_within_an_Established_Connection)

---

#### sshuttle: where transparent proxy meets VPN meets ssh

<!--https://sshuttle.readthedocs.io/en/stable/manpage.html: -->
> sshuttle allows you to create a VPN connection from your machine to any remote server that you can connect to via ssh, as long as that server has a sufficiently new Python installation.
> 
> To work, you must have root access on the local machine, but you can have a normal account on the server.
> 
> It’s valid to run sshuttle more than once simultaneously on a single client machine, connecting to a different server every time, so you can be on more than one VPN at once.
> 
> If run on a router, sshuttle can forward traffic for your entire subnet to the VPN.

---

## SSH and Visual Studio Code

[Remote development over SSH](https://code.visualstudio.com/docs/remote/ssh-tutorial)  
[Remote Development using SSH](https://code.visualstudio.com/docs/remote/ssh)
