#!/bin/sh
# as long as /var/lib/dpkg/info/apache2.postinst has no migration code, we need this script
# for details see http://anonscm.debian.org/cgit/pkg-apache/apache2.git/plain/debian/apache2.NEWS
APACHE2BASEDIR="/tmp/apache2"

# migrate vHost config
for SITECONF in $(ls -l ${APACHE2BASEDIR}/sites-enabled/ | awk {'print $9'} | grep -v ^$ | grep -v ".conf$"); do
	echo "Migrating ${SITECONF}"
	mv  ${APACHE2BASEDIR}/sites-available/${SITECONF} ${APACHE2BASEDIR}/sites-available/${SITECONF}.conf
	rm ${APACHE2BASEDIR}/sites-enabled/${SITECONF}
	# a2ensite ${SITECONF}
	ln -s ../sites-available/${SITECONF}.conf ${APACHE2BASEDIR}/sites-enabled/${SITECONF}.conf
done

# migrate server config snippets
for CONF in $(ls -l ${APACHE2BASEDIR}/conf.d/ | grep -v ^l | awk {'print $9'} | grep -v ^$); do
	if ! [ ${CONF##*.} == "conf" ]; then
		mv ${APACHE2BASEDIR}/conf.d/${CONF} ${APACHE2BASEDIR}/conf.d/${CONF}.conf
		CONF="${CONF}.conf"
	fi
	mv ${APACHE2BASEDIR}/conf.d/${CONF} ${APACHE2BASEDIR}/conf-available/${CONF}
	# enable this
	CONF=$(basename ${CONF} .conf)
	a2enconf ${CONF}
done
