#!/bin/bash
if [ -f /etc/default/backuppc-helper ]
then
	. /etc/default/backuppc-helper
	if [ -z "$VOL" ]
	then
		echo "#### WARNING ####"
		echo "VOL in /etc/default/backuppc-helper not set!"
		echo "#################"
		exit 0
	fi
else
	echo "#### WARNING ####"
	echo "/etc/default/backuppc-helper is missing!"
	echo "#################"
	exit 0
fi

if [ `mount | grep ${1} | wc -l` -gt "0" ] ; then
	echo "#### WARNING ####"
	echo "/dev/${VOL}/${1}-disk already mounted!"
	echo "#################"
	exit 0
fi
mkdir -p /mnt/${1}
mount /dev/${VOL}/${1}-disk /mnt/${1}

rsync -avz --numeric-ids --delete root@${1}:/bin/ /mnt/${1}/bin/
rsync -avz --numeric-ids --delete root@${1}:/dev/ /mnt/${1}/dev/
rsync -avz --numeric-ids --delete --exclude=inittab --exclude=network/interfaces --exclude=fstab root@${1}:/etc/ /mnt/${1}/etc/
rsync -avz --numeric-ids --delete root@${1}:/home/ /mnt/${1}/home/
rsync -avz --numeric-ids --delete root@${1}:/initrd/ /mnt/${1}/initrd/
rsync -avz --numeric-ids --delete root@${1}:/lib/ /mnt/${1}/lib/
rsync -avz --numeric-ids --delete root@${1}:/media/ /mnt/${1}/media/
rsync -avz --numeric-ids --delete root@${1}:/mnt/ /mnt/${1}/mnt/
rsync -avz --numeric-ids --delete root@${1}:/opt/ /mnt/${1}/opt/
rsync -avz --numeric-ids --delete root@${1}:/root/ /mnt/${1}/root/
rsync -avz --numeric-ids --delete root@${1}:/sbin/ /mnt/${1}/sbin/
rsync -avz --numeric-ids --delete root@${1}:/srv/ /mnt/${1}/srv/
#rsync -avz --numeric-ids --delete root@${1}:/sys/ /mnt/${1}/sys/
rsync -avz --numeric-ids --delete root@${1}:/tmp/ /mnt/${1}/tmp/
rsync -avz --numeric-ids --delete root@${1}:/usr/ /mnt/${1}/usr/
rsync -avz --numeric-ids --delete root@${1}:/var/ /mnt/${1}/var/

mount --bind /proc /mnt/${1}/proc/
mount --bind /dev /mnt/${1}/dev
mount --bind /sys /mnt/${1}/sys
chroot /mnt/${1} aptitude -y purge initramfs-tools linux-image-2.6-486 linux-image-2.6.18-4-486 linux-image-2.6.18-5-486 linux-image-2.6.18-6-486 udev grub console-common console-data console-tools smartmontools hddtemp shorewall
chroot /mnt/${1} aptitude -y install libc6-xen
# chroot /mnt/${1} aptitude -y install linux-modules-2.6.18-6-xen-686

umount /mnt/${1}/proc/
umount /mnt/${1}/dev/
umount /mnt/${1}/sys/
rm -rf /mnt/${1}/var/lib/initramfs-tools/*
rm -rf /mnt/${1}/boot/*
rm -rf /mnt/${1}/sys/*
rm -rf /mnt/${1}/proc/*
rm -f  /mnt/${1}/etc/udev/rules.d/z25_persistent-net.rules
umount /mnt/${1}
