#!/bin/bash                                                                     
                                                                                
CHKSUM_DIR="${CHKSUM_DIR:-/tmp/}"                                               
CHKSUM_FILE="${CHKSUM_FILE:-files.checksum}"                                    
CHECK_DIR="$CHECK_DIR:-/var/www}"                                              
FIND_FILTER="${FIND_FILTER:--type f -name *.php}"                             
                                                                                
if [ ! -f "${CHKSUM_DIR}/${CHKSUM_FILE}" ]; then                                
        find ${CHECK_DIR} ${FIND_FILTER} -exec md5sum "{}" + > ${CHKSUM_DIR}/${CHKSUM_FILE}
else                                                                            
        md5sum --quiet -c ${CHKSUM_DIR}/${CHKSUM_FILE} || echo ""               
        TMPDIR=$(mktemp -d /tmp/d.XXXXXX)                                       
        trap 'rm -rf "${TMPDIR}"' EXIT                                          
        find ${CHECK_DIR} ${FIND_FILTER} -exec md5sum "{}" + > ${TMPDIR}/${CHKSUM_FILE}
        if [ $(diff -Nur ${CHKSUM_DIR}/${CHKSUM_FILE} ${TMPDIR}/${CHKSUM_FILE}|wc -l) -gt 0 ]; then
                echo "PHP Files have changes, please investigate!"              
                echo "To reset this detection, please remove ${CHKSUM_DIR}/${CHKSUM_FILE}"
                echo "and re-run this script!"                                  
                echo "These files have changed:"                                
                echo "======================================================================"
                diff -Nur ${CHKSUM_DIR}/${CHKSUM_FILE} ${TMPDIR}/${CHKSUM_FILE} 
        fi                                                                      
fi 