#!/bin/bash

SAN="${1}"
ACME_FILE="${2}"
TMP_DIR="$(mktemp -d /tmp/XXXXXXX)"
trap 'rm -rf -- "${TMP_DIR}"' EXIT

if [ ! -f "${ACME_FILE}" ] || [ -z "${ACME_FILE}" ] ; then
	echo "error: acme file (${ACME_FILE}) missing"
	exit
fi

jq -r '.[].Certificates[] | select(.domain.main == "'"${SAN}"'") | .certificate' "${ACME_FILE}" | base64 -d > "${TMP_DIR}/${SAN}.pem"
jq -r '.[].Certificates[] | select(.domain.main == "'"${SAN}"'") | .key' "${ACME_FILE}" | base64 -d > "${TMP_DIR}/${SAN}.key"

# Check if new key and cert files exists
if [ -f "${TMP_DIR}/${SAN}.pem" ] && [ -f "${TMP_DIR}/${SAN}.key" ]; then
	# Check if new key and cert files are not empty
	if [ -s "${TMP_DIR}/${SAN}.pem" ] && [ -s "${TMP_DIR}/${SAN}.key" ]; then
		# Check if old certs/keys exists
		if [ -f "/etc/ssl/certs/${SAN}.pem" ] && [ -f "/etc/ssl/private/${SAN}.key" ]; then
			# Check if old and new certs/keys are different
			if [ "$(md5sum "/etc/ssl/private/${SAN}.key" | cut -d ' ' -f 1)" != "$(md5sum "${TMP_DIR}/${SAN}.key" | cut -d ' ' -f 1)" ] || [ "$(md5sum "/etc/ssl/certs/${SAN}.pem" | cut -d ' ' -f 1)" != "$(md5sum "${TMP_DIR}/${SAN}.pem" | cut -d ' ' -f 1)"  ]; then
				# backup key
				if [ -f "/etc/ssl/private/${SAN}.key" ]; then
					mv "/etc/ssl/private/${SAN}.key" "/etc/ssl/private/${SAN}.key.old"
				fi
				# backup cert
				if [ -f "/etc/ssl/certs/${SAN}.pem" ]; then
					mv "/etc/ssl/certs/${SAN}.pem" "/etc/ssl/certs/${SAN}.pem.old"
				fi
			else
				exit
			fi
		fi
		# copy key
		cp "${TMP_DIR}/${SAN}.key" "/etc/ssl/private/${SAN}.key"
		# copy cert
		cp "${TMP_DIR}/${SAN}.pem" "/etc/ssl/certs/${SAN}.pem"
	else
		exit
	fi
else
	exit
fi