#!/bin/sh
# install needed curl package
sudo apt install --no-install-recommends curl  -y
# install kubectl
curl -Lo /tmp/kubectl https://storage.googleapis.com/kubernetes-release/release/$(curl -s https://storage.googleapis.com/kubernetes-release/release/stable.txt)/bin/linux/amd64/kubectl && \
 chmod +x /tmp/kubectl && \
 sudo mv /tmp/kubectl /usr/local/bin/kubectl
# kubectl tab completion
sudo sh -c 'echo "source <(kubectl completion bash)" > /etc/bash_completion.d/kubectl'
# install needed packages for kvm (see https://github.com/kubernetes/minikube/blob/master/docs/drivers.md#kvm2-driver)
sudo apt install --no-install-recommends curl libvirt-bin qemu-kvm -y
sudo usermod -a -G libvirtd $(whoami)
newgrp libvirtd
# download and install the kvm docker machine driver
curl -Lo /tmp/docker-machine-driver-kvm2 https://storage.googleapis.com/minikube/releases/latest/docker-machine-driver-kvm2 && \
 chmod +x /tmp/docker-machine-driver-kvm2 && \
 sudo mv /tmp/docker-machine-driver-kvm2 /usr/bin/
# install minikube
curl -Lo /tmp/minikube https://storage.googleapis.com/minikube/releases/latest/minikube-linux-amd64 && \
 chmod +x /tmp/minikube && \
 sudo mv /tmp/minikube /usr/local/bin/minikube

minikube start --vm-driver=kvm2
