#!/bin/sh
# install needed
sudo apt-get install curl -y
# install kubectl
curl -Lo /tmp/kubectl https://storage.googleapis.com/kubernetes-release/release/$(curl -s https://storage.googleapis.com/kubernetes-release/release/stable.txt)/bin/linux/amd64/kubectl && \
 chmod +x /tmp/kubectl && \
 sudo mv /tmp/kubectl /usr/local/bin/kubectl
# kubectl tab completion
sudo sh -c 'echo "source <(kubectl completion bash)" >> /etc/bash_completion.d/kubectl'
# install minikube
curl -Lo /tmp/minikube https://storage.googleapis.com/minikube/releases/latest/minikube-linux-amd64 && \
 chmod +x /tmp/minikube && \
 sudo mv /tmp/minikube /usr/local/bin/minikube
# be lazy and use UNSECURE vm driver "none"
export MINIKUBE_WANTUPDATENOTIFICATION=false
export MINIKUBE_WANTREPORTERRORPROMPT=false
export MINIKUBE_HOME=$HOME
export CHANGE_MINIKUBE_NONE_USER=true
mkdir -p $HOME/.kube || true
touch $HOME/.kube/config
export KUBECONFIG=$HOME/.kube/config

sudo minikube start --vm-driver=none
