Deploying [dehydrated](http://dehydrated.de) for apache2 on Debian Jessie:

```
wget https://gist.githubusercontent.com/waja/8df78afb09691e4f383d818685f48885/raw/deploy_dehydrated.sh \
 -O /tmp/deploy_dehydrated.sh && \
 bash /tmp/deploy_dehydrated.sh <registration email>
```

Now you need to create ```/etc/dehydrated/domains.txt``` like [documented](https://github.com/lukas2511/dehydrated/blob/master/docs/domains_txt.md).

Running the cronjob for initial request of certs:

```
/etc/cron.daily/dehydrated_autorenew
```

If you are hit by [Provided agreement URL ... does not match current agreement URL ...](https://github.com/lukas2511/dehydrated/issues/248) you need to use at least dehydrated 0.4.0, for example from stretch-backports. Use:

```
/usr/bin/dehydrated -c --accept-terms && /etc/cron.daily/dehydrated_autorenew
```

Linking certs and keys into usual places:
```
for CERT in $(awk {'print $1'} /etc/dehydrated/domains.txt); do\
 [ -f /var/lib/dehydrated/certs/${CERT}/privkey.pem ] && ! [ -L /etc/ssl/private/${CERT}.key ] && \
   ln -s /var/lib/dehydrated/certs/${CERT}/privkey.pem /etc/ssl/private/${CERT}.key;\
 [ -f /var/lib/dehydrated/certs/${CERT}/fullchain.pem ] && ! [ -L /etc/ssl/certs/${CERT}.pem ] && \
   ln -s /var/lib/dehydrated/certs/${CERT}/fullchain.pem /etc/ssl/certs/${CERT}.pem;\
done
```

For distributed setups you might want to have a look into [Using redirects](https://nekudo.com/blog/letsencrypt-in-a-multiserver-environment) or [Use and automate letsencrypt certificates (ACME) in an high-availability environment](https://chr4.org/blog/2016/11/14/use-letsencrypt-acme-in-an-high-availability-environment/).
