# install (transition) package
aptitude -t jessie-backports install letsencrypt.sh letsencrypt.sh-apache2 && \
# migrate config over to dehydrated
sed -i s/letsencrypt\.sh/dehydrated/g /etc/cron.daily/letsencrypt_autorenew && mv /etc/cron.daily/letsencrypt_autorenew /etc/cron.daily/dehydrated_autorenew && \
mv /var/lib/letsencrypt.sh/certs/ /var/lib/letsencrypt.sh/accounts/ /var/lib/dehydrated/ && \
mv /etc/letsencrypt.sh/conf.d/* /etc/dehydrated/conf.d/ && \
mv /etc/letsencrypt.sh/domains.txt /etc/letsencrypt.sh/hook.sh /etc/dehydrated/ && \
sed -i s/letsencrypt\.sh/dehydrated/g /etc/dehydrated/conf.d/*

# migrate certificate links to dehydrated
for CERT in $(awk {'print $1'} /etc/dehydrated/domains.txt); do \
 test -L /etc/ssl/certs/$CERT.pem && rm /etc/ssl/certs/$CERT.pem; \
 test -L /etc/ssl/private/$CERT.key && rm /etc/ssl/private/$CERT.key; \
 test -e /var/lib/dehydrated/certs/${CERT}/privkey.pem && \
 ln -s /var/lib/dehydrated/certs/${CERT}/privkey.pem /etc/ssl/private/${CERT}.key; \
 test -e /var/lib/dehydrated/certs/${CERT}/fullchain.pem && \
 ln -s /var/lib/dehydrated/certs/${CERT}/fullchain.pem /etc/ssl/certs/${CERT}.pem; \
done

# remove obsolete apache configuration and reload apache2
rm /etc/apache2/conf-available/letsencrypt.sh.conf /etc/apache2/conf-enabled/letsencrypt.sh.conf && /etc/init.d/apache2 reload
