#!/bin/bash
CRON="/etc/cron.daily/dehydrated_autorenew"
CONFIGURL="https://gist.githubusercontent.com/waja/8df78afb09691e4f383d818685f48885/raw/local.sh"
CONFIGNAME="$(basename ${CONFIGURL})"
CONFIGPATH="/etc/dehydrated/conf.d/"
HOOKNAME="hook.sh"
HOOKPATH="/etc/dehydrated/"
SUITE="jessie-backports"
PACKAGES="dehydrated dehydrated-apache2"

apt-get install -t ${SUITE} ${PACKAGES}

if [ ! -x ${CRON} ]; then
	echo '#!/bin/bash' > ${CRON}
	echo 'test -x /usr/bin/dehydrated && /usr/bin/dehydrated -c | grep -v -E "(^#|^Processing|Skipping renew|unchanged|Checking expire date of existing cert|Certificate will not expire|^$)"; exit 0' >> ${CRON}
	chmod +x ${CRON}
fi

[ -f ${CONFIGPATH}/${CONFIGNAME} ] || wget ${CONFIGURL} -O ${CONFIGPATH}/${CONFIGNAME}

sed -i "s/^CONTACT_EMAIL=*/CONTACT_EMAIL=${1}/" ${CONFIGPATH}/${CONFIGNAME}
[ -f ${HOOKPATH}/${HOOKNAME} ] || printf '#!/bin/sh\n\n# See also https://github.com/lukas2511/dehydrated/blob/master/docs/examples/hook.sh\n\n[ "$1" != "deploy_cert" ] || /usr/sbin/service apache2 restart' > ${HOOKPATH}/${HOOKNAME} && chmod +x ${HOOKPATH}/${HOOKNAME}
