Deploying [letsencrypt.sh](http://letsencrypt.sh) for apache2 on Debian Jessie:

```
wget https://gist.githubusercontent.com/waja/8df78afb09691e4f383d818685f48885/raw/deploy_letsencrypth.sh \
 -O /tmp/deploy_letsencrypth.sh && \
 bash /tmp/deploy_letsencrypth.sh <registration email>
```

Now you need to create ```/etc/letsencrypt.sh/domains.txt``` like [documented](https://github.com/lukas2511/dehydrated/blob/master/docs/domains_txt.md).

Running the cronjob for initial request of certs:

```
/etc/cron.daily/letsencrypt_autorenew
```

Linking certs and keys into usual places:
```
for CERT in $(awk {'print $1'} /etc/letsencrypt.sh/domains.txt); do\
 [ -e /var/lib/letsencrypt.sh/certs/${CERT}/privkey.pem ] || \
   ln -s /var/lib/letsencrypt.sh/certs/${CERT}/privkey.pem /etc/ssl/private/${CERT}.key;\
 [ -e /var/lib/letsencrypt.sh/certs/${CERT}/fullchain.pem ] || \
   ln -s /var/lib/letsencrypt.sh/certs/${CERT}/fullchain.pem /etc/ssl/certs/${CERT}.pem;\
done
```
