Deploying [dehydrated](http://dehydrated.de) for apache2 on Debian Jessie:

```
wget https://gist.githubusercontent.com/waja/8df78afb09691e4f383d818685f48885/raw/deploy_dehydrated.sh \
 -O /tmp/deploy_dehydrated.sh && \
 bash /tmp/deploy_dehydrated.sh <registration email>
```

Now you need to create ```/etc/dehydrated/domains.txt``` like [documented](https://github.com/lukas2511/dehydrated/blob/master/docs/domains_txt.md).

Running the cronjob for initial request of certs:

```
/etc/cron.daily/dehydrated_autorenew
```

Linking certs and keys into usual places:
```
for CERT in $(awk {'print $1'} /etc/dehydrated/domains.txt); do\
 [ -f /var/lib/dehydrated/certs/${CERT}/privkey.pem ] && \
   ln -s /var/lib/dehydrated/certs/${CERT}/privkey.pem /etc/ssl/private/${CERT}.key;\
 [ -f /var/lib/dehydrated/certs/${CERT}/fullchain.pem ] && \
   ln -s /var/lib/dehydrated/certs/${CERT}/fullchain.pem /etc/ssl/certs/${CERT}.pem;\
done
```
