#!/bin/bash
CRON="/etc/cron.daily/letsencrypt_autorenew"
CONFIGURL="https://gist.githubusercontent.com/waja/8df78afb09691e4f383d818685f48885/raw/local.sh"
CONFIGNAME="$(basename ${CONFIGURL})"
CONFIGPATH="/etc/letsencrypt.sh/conf.d/"
HOOKNAME="hook.sh"
HOOKPATH="/etc/letsencrypt.sh/"
SUITE="jessie-backports"
PACKAGES="letsencrypt.sh letsencrypt.sh-apache2"

apt-get install -t ${SUITE} ${PACKAGES}

if [ ! -x ${CRON} ]; then
	echo '#!/bin/bash' > ${CRON}
	echo 'test -x /usr/bin/letsencrypt.sh && /usr/bin/letsencrypt.sh -c | grep -v -E "(^#|^Processing|Skipping renew|unchanged|Checking expire date of existing cert|^$)"; exit 0' >> ${CRON}
	chmod +x ${CRON}
fi

[ -f ${CONFIGPATH}/${CONFIGNAME} ] || wget ${CONFIGURL} -O ${CONFIGPATH}/${CONFIGNAME}

sed -i "s/^CONTACT_EMAIL=*/CONTACT_EMAIL=${1}/" ${CONFIGPATH}/${CONFIGNAME}
[ -f ${HOOKPATH}/${HOOKNAME} ] || printf '#!/bin/sh\n[ "$1" != "deploy_cert" ] || /usr/sbin/service apache2 restart' > ${HOOKPATH}/${HOOKNAME} && chmod +x ${HOOKPATH}/${HOOKNAME}
