#!/bin/bash
CRON="/etc/cron.daily/dehydrated_autorenew"
CONFIGURL="https://gist.githubusercontent.com/waja/8df78afb09691e4f383d818685f48885/raw/local.sh"
CONFIGNAME="$(basename ${CONFIGURL})"
CONFIGPATH="/etc/dehydrated/conf.d/"
LINKSCRIPT="/usr/local/sbin/dehydrated_create_links"
HOOKNAME="hook.sh"
HOOKPATH="/etc/dehydrated/"
if [ "$(lsb_release -cs)" = "jessie" ]; then
	BPO="-t $(lsb_release -cs)-backports"
fi
PACKAGES="dehydrated dehydrated-apache2"

apt-get install -y ${BPO} ${PACKAGES}

if [ ! -x ${CRON} ]; then
        cat > ${CRON} <<EOF
#!/bin/bash
test -x /usr/bin/dehydrated && /usr/bin/dehydrated -c -g | grep -v -E "(^#|^Processing|Skipping renew|unchanged|Checking expire date of existing cert|Certificate will not expire|^$)"; exit 0
EOF
	chmod +x ${CRON}
fi

cat > ${LINKSCRIPT} << EOF
#!/bin/bash
for CERT in \$(awk {'print \$1'} /etc/dehydrated/domains.txt); do [ -f /var/lib/dehydrated/certs/\${CERT}/privkey.pem ] && ! [ -L /etc/ssl/private/\${CERT}.key ] &&    ln -s /var/lib/dehydrated/certs/\${CERT}/privkey.pem /etc/ssl/private/\${CERT}.key; [ -f /var/lib/dehydrated/certs/\${CERT}/fullchain.pem ] && ! [ -L /etc/ssl/certs/\${CERT}.pem ] &&    ln -s /var/lib/dehydrated/certs/\${CERT}/fullchain.pem /etc/ssl/certs/\${CERT}.pem;done
EOF
chmod +x ${LINKSCRIPT}

# Fix #941414 (for now)
sed -i "s/grep Replay-Nonce:/grep -i ^Replay-Nonce:/" /usr/bin/dehydrated

[ -f ${CONFIGPATH}/${CONFIGNAME} ] || wget ${CONFIGURL} -O ${CONFIGPATH}/${CONFIGNAME}

sed -i "s/^CONTACT_EMAIL=*/CONTACT_EMAIL=${1}/" ${CONFIGPATH}/${CONFIGNAME}
[ -f ${HOOKPATH}/${HOOKNAME} ] || printf '#!/bin/sh\n\n# See also https://github.com/lukas2511/dehydrated/blob/master/docs/examples/hook.sh\n\n[ "$1" != "deploy_cert" ] || /usr/sbin/service apache2 restart' > ${HOOKPATH}/${HOOKNAME} && chmod +x ${HOOKPATH}/${HOOKNAME}
