#!/bin/bash
# Creating some temp dir
TMPDIR=$(mktemp -d /tmp/d.XXXXXX) && \
trap 'rm -rf "${TMPDIR}"' EXIT && \
# Install lazydocker
LAZYDOCKER_VERSION=$(curl -L -s -H 'Accept: application/json' https://github.com/jesseduffield/lazydocker/releases/latest | sed -e 's/.*"tag_name":"\([^"]*\)".*/\1/') && \
GITHUB_FILE="lazydocker_${LAZYDOCKER_VERSION//v/}_$(uname -s)_$(uname -m).tar.gz" && \
GITHUB_URL="https://github.com/jesseduffield/lazydocker/releases/download/${LAZYDOCKER_VERSION}/${GITHUB_FILE}" && \
curl -o ${TMPDIR}/lazydocker.tar.gz -L ${GITHUB_URL} && \
tar xzvf ${TMPDIR}/lazydocker.tar.gz -C ${TMPDIR} && \
mv -f ${TMPDIR}/lazydocker /usr/local/bin/