#!/bin/bash

if [ -r /opt/etc/default/backuppc-achive-rclone ]; then
    source /opt/etc/default/backuppc-achive-rclone
else
    source /etc/default/backuppc-achive-rclone
fi

if [ -r /opt/etc/backuppc-achive-rclone.conf ]; then
    source /opt/etc/backuppc-achive-rclone.conf
else
    source /etc/backuppc-achive-rclone.conf
fi

BACKUPPC_HOSTS="${BACKUPPC_HOSTS:=/etc/backuppc/hosts}"
BACKUPPC_ARCHIVESTART="${BACKUPPC_ARCHIVESTART:=/usr/share/backuppc/bin/BackupPC_archiveStart}"
BACKUPPC_ARCHIVE_RENTENTION="${BACKUPPC_ARCHIVE_RENTENTION:=2}"
RCLONE_BIN="${RCLONE_BIN:=rclone}"
RCLONE_BUCKET="${RCLONE_BUCKET:=backuppc-archive}"
RCLONE_BWLIMIT="${RCLONE_BWLIMIT:="06:00,512 22:00,1M"}"
HEAD="$(which /opt/bin/head || which head)"

[ -z ${RCLONE_REMOTE} ] && { echo "E: please set RCLONE_REMOTE in /opt/etc/backuppc-achive-rclone.conf or /etc/backuppc-achive-rclone.conf!"; exit 1; }
[ -z ${RCLONE_BUCKET} ] && { echo "E: please set RCLONE_BUCKET in /opt/etc/backuppc-achive-rclone.conf or /etc/backuppc-achive-rclone.conf!"; exit 1; }
[ -z ${BACKUPPC_ARCHIVE_PATH} ] && { echo "E: please set BACKUPPC_ARCHIVE_PATH in /opt/etc/backuppc-achive-rclone.conf or /etc/backuppc-achive-rclone.conf!"; exit 1; }
[ -z ${BACKUPPC_PC_PATH} ] && { echo "E: please set BACKUPPC_PC_PATH in /opt/etc/backuppc-achive-rclone.conf or /etc/backuppc-achive-rclone.conf!"; exit 1; }

get_backup_hosts() {
    # Taken from https://brb.epr.ch/blog/_export/code/blog:backuppc_script_archive_all_hosts?codeblock=0
    HOSTS=""
    while read -r LINE; do
        # Skip comments
        [[ "${LINE}" =~ ^#.*$ ]] && continue

        HOST=`echo ${LINE} | cut -f 1 -d " "`
        ! [ "${HOST}" != "" -a "${HOST}" != "archive" -a "${HOST}" != "host" ] && continue

        HOSTS="${HOSTS} ${HOST}"
    done < "${BACKUPPC_HOSTS}"
}

get_archived_hosts() {
    for FILE in ${BACKUPPC_ARCHIVE_PATH}/*; do
        basename $FILE .tar.bz2 | sed 's/\.[[:digit:]]\+.*//g';
    done | uniq
}

get_archived_host_files() {
    ${HEAD} -n -1 /proc/cpuinfo > /dev/null 2>&1 || { echo "E: head command does not support '-n' option."; exit 1; }
    ARCHIVED_HOSTS="$(get_archived_hosts)"
    for FILEHOSTNAME in $(get_archived_hosts); do
        ls -a ${BACKUPPC_ARCHIVE_PATH}/${FILEHOSTNAME}* | ${HEAD} -n -${BACKUPPC_ARCHIVE_RENTENTION}
    done
}

archive_hosts() {
    BACKUPPC_ARCHIVE_HOSTS=""
    for CHECK_HOST in ${HOSTS}; do
        BACKUPPC_LATEST_BACKUP="$(tail -1 ${BACKUPPC_PC_PATH}/${CHECK_HOST}/backups | cut -d$'\t' -f1)"
        [ -f ${BACKUPPC_ARCHIVE_PATH}/${CHECK_HOST}.${BACKUPPC_LATEST_BACKUP}.tar.* ] || BACKUPPC_ARCHIVE_HOSTS="${BACKUPPC_ARCHIVE_HOSTS} ${CHECK_HOST}"
    done
    ${BACKUPPC_ARCHIVESTART} archive backuppc ${BACKUPPC_ARCHIVE_HOSTS}
}

case ${1} in
    export)
        get_backup_hosts
        echo Backing up ${HOSTS}
        if [ "$(whoami)" != "backuppc" ]; then
            BACKUPPC_ARCHIVESTART="sudo -u backuppc ${BACKUPPC_ARCHIVESTART}"
        fi
        archive_hosts
        ;;
    sync)
	if [ -z "${RCLONE_BWLIMIT}" ]; then
        	${RCLONE_BIN} sync ${BACKUPPC_ARCHIVE_PATH} ${RCLONE_REMOTE}:${RCLONE_BUCKET}
	else
        	${RCLONE_BIN} sync ${BACKUPPC_ARCHIVE_PATH} ${RCLONE_REMOTE}:${RCLONE_BUCKET} --bwlimit "${RCLONE_BWLIMIT}"
	fi
        ;;
    cleanup)
	[ -z "$(get_archived_host_files)" ] && { echo "W: Nothing to clean up at the moment"; exit 0; }
        rm $(get_archived_host_files)
        ;;
    *)
        echo "ERROR: Use the following keywords:"
        echo "'export' for queuing BackupPC archive export"
        echo "'sync' to start rcloud sync"
        echo "'cleanup' for removing unneeded archives"
        exit 1
esac
