#!/bin/bash

DATE="$(date +%d)"

psql_user="postgres"
psql_host="/var/run/postgresql/"
psql_port="5432"

[ -f /opt/gitlab/etc/gitlab-psql-rc ] && . /opt/gitlab/etc/gitlab-psql-rc

su - ${psql_user} -c "pg_dumpall -g --host=${psql_host}" > /var/backups/db_dumps/psql_roles.sql-$DATE
gzip -f /var/backups/db_dumps/psql_roles.sql-$DATE
su - ${psql_user} -c "pg_dumpall --host=${psql_host}" > /var/backups/db_dumps/pgsqldump-$DATE
gzip -f /var/backups/db_dumps/pgsqldump-$DATE
find /var/backups/db_dumps/*.gz -mtime +14 -exec rm {} +