# Deploying [Letsencrypt](https://letsencrypt.org/) certificates with [Docker](http://docker.org).

## Preparing Docker environment and configure letsencrypt 
```sh
mkdir -p /srv/docker/letsencrypt/etc/
mkdir -p /srv/docker/letsencrypt/log
chmod 700 /srv/docker/letsencrypt/log
mkdir -p /srv/docker/letsencrypt/lib/webrootauth
mkdir /etc/letsencrypt/                                                         
ln -s /srv/docker/letsencrypt/etc/live/ /etc/letsencrypt/
cat > /srv/docker/letsencrypt/etc/webroot.ini <<EOF
# Use a 4096 bit RSA key instead of 2048
rsa-key-size = 4096

# Always use the staging/testing server
server = https://acme-v01.api.letsencrypt.org/directory

# Uncomment and update to register with the specified e-mail address
email = <email>

# Use the text output instead of the curses UI.
text = True

# Agree Terms of Service
agree-tos = True

# Select renewal by default
# renew-by-default = True

# Use webroot authenticator plugin
authenticator = webroot

# Define webroot path for authenticator plugin
webroot-path = /var/lib/letsencrypt/webrootauth  
EOF
```

## Request certificate

```sh
docker run --rm --name letsencrypt -v "/srv/docker/letsencrypt/log:/var/log/letsencrypt" -v "/srv/docker/letsencrypt/etc:/etc/letsencrypt" -v "/srv/docker/letsencrypt/lib:/var/lib/letsencrypt" quay.io/letsencrypt/letsencrypt:latest --webroot-path "/var/lib/letsencrypt/webrootauth" -c "/etc/letsencrypt/webroot.ini" -d <domain> certonly
```

## Renew

```sh
cat > /etc/cron.daily/letsencrypt_autorenew << EOF
#!/bin/bash                                                                     

docker run --rm --name letsencrypt -v "/srv/docker/letsencrypt/log:/var/log/letsencrypt" -v "/srv/docker/letsencrypt/etc:/etc/letsencrypt" -v "/srv/docker/letsencrypt/lib:/var/lib/letsencrypt" quay.io/letsencrypt/letsencrypt:latest --webroot-path "/var/lib/letsencrypt/webrootauth" -c "/etc/letsencrypt/webroot.ini" renew | grep -v -E "(^Processing|certs are not due for renewal|skipped|^No renewals were attempted|^$)"
if [ $(find /etc/letsencrypt/live/*/cert.pem -mmin -5|wc -l) -gt 0 ]; then
	/etc/init.d/nginx reload;
fi
EOF
chmod +x /etc/cron.daily/letsencrypt_autorenew
```