#!/bin/bash                                                                     
                                                                                
# This is a script to create a video from series of JPEG images                 
# Call it in a folder full of JPEGs that you want to turn into a video.         
# Written on 2013-01-08 by Philipp Klaus <philipp.l.klaus →AT→ web.de>.         
# Check <https://gist.github.com/4572552> for newer versions.
# Modified Version from: nv1t (coz of many image files)                   
                                                                                
# Resources                                                                     
# * http://www.itforeveryone.co.uk/image-to-video.html                          
# * http://spielwiese.la-evento.com/hokuspokus/index.html                       
# * http://ffmpeg.org/trac/ffmpeg/wiki/Create%20a%20video%20slideshow%20from%20images
# * http://wiki.ubuntuusers.de/FFmpeg                                           
                                                                                
set -x                                                                          
                                                                                
FRAMERATE=24                                                                    
RESOLUTION=800x600                                                              
                                                                                
# Rename the images into a sequence                                             
# http://www.ralree.com/2008/08/06/renaming-files-sequentially-with-bash/       
EII=1                                                                           
# If sorting according to the file date, copy them using   cp -a ../*.JPG ./                                                                    
for i in $(ls -tr *.JPG); do                                                                                                                             
  NEWNAME=IMG_$(printf "%06d" $EII).JPG                                          
  #echo Renaming $i to $NEWNAME                                                 
  mv "${i}" "rename/${NEWNAME}"                                                 
  mogrify -resize $RESOLUTION "rename/${NEWNAME}"                               
  EII=$(($EII+1))                                                               
done                                                                            
                                                                                
# Now create the video using ffmpeg                                             
#cat rename/*.JPG | ffmpeg -f image2pipe -r $FRAMERATE -vcodec mjpeg -i - -vcodec libx264 out_$FRAMERATE.mp4
ffmpeg -f image2 -r $FRAMERATE -i rename/IMG_%06d.JPG movie_$FRAMERATE.mp4