#!/bin/bash
# wget https://gist.githubusercontent.com/waja/0deb4dd5cd759371270dc3e1f5dabcb5/raw/deploy_rootlessdocker.sh -O /tmp/a && sh /tmp/a

# Check if dockerd is installed
[ $(which dockerd) ] || wget https://gist.githubusercontent.com/waja/01ba2641f93f461044f9/raw/docker_deploy.sh \
  -O /tmp/docker_deploy.sh && bash /tmp/docker_deploy.sh

# Stop and disable dockerd (runs as root)
systemctl stop docker && systemctl disable docker

# Install curl and needed (new) slirp4netns
apt update && apt install -y curl && \
 apt -t buster-backports install -y slirp4netns

# Download and install docker rootless
tmp=$(mktemp -d)
trap "rm -rf $tmp" EXIT INT TERM
STATIC_RELEASE_ROOTLESS_URL="https://master.dockerproject.org/linux/x86_64/docker-rootless-extras.tgz"
ROOTLESS_BIN="/usr/local/bin/"
cd "$tmp"
curl -L -o rootless.tgz "$STATIC_RELEASE_ROOTLESS_URL"
tar zxf "$tmp/rootless.tgz" -C "$ROOTLESS_BIN" --strip-components=1

# https://github.com/moby/moby/blob/master/docs/rootless.md#debian-excluding-ubuntu
# https://github.com/moby/moby/blob/master/docs/rootless.md#routing-ping-packets
cat <<EOF | sh -x
apt install -y uidmap
cat <<EOT > /etc/sysctl.d/50-rootless.conf
kernel.unprivileged_userns_clone = 1
net.ipv4.ping_group_range = 0   2147483647
EOT
sysctl --system
EOF

cat <<EOF > /etc/profile.d/docker-rootless.sh
export XDG_RUNTIME_DIR=/tmp/docker-\${UID}
[ -d \${XDG_RUNTIME_DIR} ] || mkdir \${XDG_RUNTIME_DIR}
export DOCKER_HOST=unix:///tmp/docker-\${UID}/docker.sock
export PATH=\$PATH:/sbin
alias dockerd-rootless='dockerd-rootless.sh --experimental --storage-driver vfs'
EOF
