* [Meltdown and Spectre - Vulnerabilities in modern computers leak passwords and sensitive data.](https://spectreattack.com/)
* [Project Zero team at Google: Reading privileged memory with a side-channel](https://googleprojectzero.blogspot.de/2018/01/reading-privileged-memory-with-side.html)
* [xorlgr - Thoughts on Meltdown & Spectre](https://xorl.wordpress.com/2018/01/10/thoughts-on-meltdown-spectre/)
* [BSI: Prozessor-Schwachstellen: Spectre und Meltdown](https://www.bsi-fuer-buerger.de/BSIFB/DE/Service/Aktuell/Informationen/Artikel/Meltdown_Spectre_Sicherheitsluecke_10012018.html)

## Desktop

### Browsers

* https://support.google.com/faqs/answer/7622138#chrome
* https://blog.mozilla.org/security/2018/01/03/mitigations-landing-new-class-timing-attack/
* https://blog.gpunktschmitz.de/381-firefox-automatisches-fuellen-von-login-forms-deaktivieren

### Microsoft

* [SpecuCheck - a Windows utility for checking the state of the software mitigations against Meltdown and Spectre](https://ionescu007.github.io/SpecuCheck/)

#### Windows 10

* [KB4056892 (OS Build 16299.192)](https://support.microsoft.com/en-us/help/4056892/windows-10-update-kb4056892)

### Apple

* https://support.apple.com/en-us/HT208394

#### iOS

* 11.2: https://support.apple.com/de-de/HT208334
* 11.2.1: https://support.apple.com/de-de/HT208334
* 11.2.2: https://support.apple.com/en-us/HT208401

#### macOS

* 10.3.2: https://support.apple.com/de-de/HT208331
* 10.3.2: https://support.apple.com/en-us/HT208397

### Android

* [Meltdown and Spectre updates](https://9to5google.com/2018/01/10/meltdown-spectre-android-updates/)

## Servers / Cloud

* [Meltdown and Spectre kernel update per operating system](https://docs.ovh.com/fr/dedicated/meltdown-spectre-kernel-update-per-operating-system/)

### VMWare

* https://lists.vmware.com/pipermail/security-announce/2018/000397.html

### KVM

* https://twitter.com/olesovhcom/status/949214617510842369

### Microsoft

* [Microsoft: Guidance to mitigate speculative execution side-channel vulnerabilities](https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/ADV180002)

### Ubuntu

* [Information Leak via speculative execution side channel attacks](https://wiki.ubuntu.com/SecurityTeam/KnowledgeBase/SpectreAndMeltdown)

## Random Links

* [Known bugs sitting in upstream LTS kernels](https://news.ycombinator.com/item?id=16087736)
* [Meltdown and Spectre in Debian - 10.01.2018](https://www.decadent.org.uk/ben/blog/meltdown-and-spectre-in-debian.html)
* [Meltdown: What’s the performance impact and how to minimise it?](https://www.opsian.com/blog/meltdown-benchmarks/)
* [iPhone performance benchmarks after Spectre security update](https://melv1n.com/iphone-performance-benchmarks-after-spectre-update/)
* [Inside Meltdown and Spectre: Interview with Anders Fogh](https://www.gdatasoftware.com/blog/2018/01/30333-inside-meltdown-spectre)