#!/bin/sh
if [ -z "${1}" ]
then
	echo "Specify which database are you using: [ --mysql | --postgresql ]"
	exit 0
fi
case ${1} in
	--mysql)
		BUNDLE_EXCLUDE="postgres"
		;;
	--postgresql)
		BUNDLE_EXCLUDE="mysql"
		;;
	*)
	echo "Specify which database are you using: [ --mysql | --postgresql ]"
	exit 0
		;;
esac

# backup
cd /home/git/gitlab
sudo -u git -H bundle exec rake gitlab:backup:create RAILS_ENV=production
# stop server
sudo service gitlab stop
# get latest code from stable branch
cd /home/git/gitlab
sudo -u git -H git fetch --all
sudo -u git -H git checkout -- Gemfile.lock db/schema.rb
LATEST_TAG=$(git tag -l 'v*.[0-9]' --sort='v:refname'| tail -1)
#LATEST_TAG=$(git describe --tags `git rev-list --tags --max-count=1`)
sudo -u git -H git checkout $LATEST_TAG -b $LATEST_TAG
# updating git-shell to corresponding version
cd /home/git/gitlab-shell
sudo -u git -H git fetch
sudo -u git -H git checkout v`cat /home/git/gitlab/GITLAB_SHELL_VERSION` -b v`cat /home/git/gitlab/GITLAB_SHELL_VERSION`
# update gitlab-workhorse to the corresponding version
cd /home/git/gitlab-workhorse
sudo -u git -H git fetch
sudo -u git -H git checkout `cat /home/git/gitlab/GITLAB_WORKHORSE_VERSION` -b `cat /home/git/gitlab/GITLAB_WORKHORSE_VERSION` && sudo -u git -H make
# install libs, migrations, etc.
cd /home/git/gitlab
sudo -u git -H bundle install --without development test ${BUNDLE_EXCLUDE} --deployment
sudo -u git -H bundle clean
sudo -u git -H bundle exec rake db:migrate RAILS_ENV=production
sudo -u git -H bundle exec rake assets:clean assets:precompile cache:clear RAILS_ENV=production
# start application
sudo service gitlab start
sudo service nginx restart
# check application status
sudo -u git -H bundle exec rake gitlab:env:info gitlab:check RAILS_ENV=production
