#!/bin/sh
TEMPDIR=/tmp/iOSbackup

## create temp directory
mkdir -p /tmp/iOSbackup

## save Documents
mkdir -p /tmp/iOSbackup/var/mobile/Documents/Downloads/
cp -a /var/mobile/Documents/Downloads/* /tmp/iOSbackup/var/mobile/Documents/Downloads/

## save source.lists
mkdir -p /tmp/iOSbackup//etc/apt/sources.list.d/
cp -a /etc/apt/sources.list.d/* /tmp/iOSbackup//etc/apt/sources.list.d/

## save packages list
dpkg -l | grep -v "gsc." > /tmp/iOSbackup/packages.list

## save more more exact package list
# get actual installed package list
dpkg --get-selections | grep -v ^gsc > /tmp/iOSbackup/installed-apps.list
# install aptitude and dump auto installed packages
apt-get -y install aptitude && aptitude search "~M" -F "%p" --disable-columns > /tmp/iOSbackup/auto-installed-apps.txt
# add aptitude to auto installed ppackages if needed
grep aptitude /tmp/iOSbackup/installed-apps.list || echo "aptitude" >> /tmp/iOSbackup/auto-installed-apps.txt
# strip out the auto installed packages from list
for i in $(cat /tmp/iOSbackup/auto-installed-apps.txt); do sed -i /^$i/d /tmp/iOSbackup/installed-apps.list; done
# remove aptitude if it was not installed before
grep aptitude /tmp/iOSbackup/installed-apps.list || apt-get -y remove aptitude && apt-get -y autoremove

## save Ringtones
mkdir -p /tmp/iOSbackup/Library/Ringtones/
mkdir -p /tmp/iOSbackup/var/stash/Ringtones.agHnw2/
cp -a /var/stash/Ringtones.agHnw2/* /tmp/iOSbackup/var/stash/Ringtones.agHnw2/

## GBA4iOS (FIXME)
find / -name *.gba
mkdir -p /tmp/iOSbackup//var/mobile/Applications/3D1E2E73-4B29-4123-AE25-6B3E0467CB46/
cp -a /var/mobile/Applications/3D1E2E73-4B29-4123-AE25-6B3E0467CB46/Documents/ /tmp/iOSbackup//var/mobile/Applications/3D1E2E73-4B29-4123-AE25-6B3E0467CB46/
## create tarball
tar -czt /tmp/iOSbackup.tar.gz /tmp/iOSbackup