#!/bin/bash

if [ $(ip -6 route | grep -c ^default) -eq 0 ]; then exit; fi
apt install socat || exit

cat > /etc/systemd/system/socat\@.service <<EOF
[Unit]
Description=ipv6 to ipv4 port forwarding
After=network.target

[Service]
Type=simple
ExecStart=/usr/bin/socat TCP6-LISTEN:%i,ipv6only=1,reuseaddr,fork TCP4:127.0.0.1:%i

[Install]
WantedBy=docker.service
EOF
systemctl daemon-reload
for PROTO in http https; do
	systemctl enable socat@${PROTO}.service
	systemctl start socat@${PROTO}.service
done
