#!/bin/bash
BASEPATH="/srv/docker/traefik2/"

export TRAEFIK_DIR="traefik2"

# Download deployment script
wget -q https://gist.githubusercontent.com/waja/37202007b10837a7fc2e6eacacd9b335/raw/deploy_traefik.sh \
 -O /tmp/deploy_traefik.sh && \
 # Remove auto start of the traefik daemon
 sed '/^systemctl/d' -i /tmp/deploy_traefik.sh && \
 sed -i '/etc\/systemd\/system\/$/d' /tmp/deploy_traefik.sh && \
 # Run deployment
 bash /tmp/deploy_traefik.sh

# Migrate settings from old toml config 
ADMIN_CRED="$(grep users ${BASEPATH}/../traefik/config/traefik.toml | cut -d \" -f2)"
EMAIL="$(grep email ${BASEPATH}/../traefik/config/traefik.toml | cut -d \" -f2)"
echo "LEMAIL=${EMAIL}" > ${BASEPATH}/.env
echo "#LEAPI=https://acme-staging-v02.api.letsencrypt.org/directory" >> ${BASEPATH}/.env
echo "DASHBOARD_USERS=${ADMIN_CRED}" >> ${BASEPATH}/.env

# Migrate old acme store to the new once
wget -q https://github.com/traefik/traefik-migration-tool/releases/download/v0.13.1/traefik-migration-tool_v0.13.1_linux_amd64.tar.gz -P /tmp
tar -xf /tmp/traefik-migration-tool_v0.13.1_linux_amd64.tar.gz -C /tmp
/tmp/traefik-migration-tool acme -i /srv/docker/traefik/config/acme.json -o /srv/docker/traefik2/config/acme-new.json

echo -e "You might want to the following:\nmv traefik traefik1 && mv traefik2 traefik && systemctl daemon-reload\ncd /srv/docker/traefik\ndocker-compose -f docker-compose.yml -f container.conf/production.yml pull\nsystemctl restart traefik && docker-compose -f docker-compose.yml -f container.conf/production.yml logs -f"
