#!/bin/bash
BASEPATH="/srv/docker/traefik/"

cp -a ${BASEPATH} /tmp/ && \
sed -i 's/^      rule:.*/      rule: "hostregexp(`.+`)"/' ${BASEPATH}/config/traefik_providers.yaml && \
sed -i "s/image: traefik:2.*/image: traefik:3.0/" ${BASEPATH}/container.conf/docker-compose.yml && \
echo "Changes made:" && \
( diff -Nuri --no-dereference ${BASEPATH} /tmp/traefik/ || true ) && \
cd ${BASEPATH} && \
docker-compose -f docker-compose.yml -f container.conf/production.yml pull && \
systemctl restart traefik && docker-compose -f docker-compose.yml -f container.conf/production.yml logs -f
