<style type="text/css">
  .reveal p {
    text-align: left;
  }
  .reveal ul {
    display: block;
  }
  .reveal ol {
    display: block;
  }
</style>

```text
 __  __           _                   _ _                  
|  \/  | ___   __| | ___ _ __ _ __   | (_)_ __  _   ___  __
| |\/| |/ _ \ / _` |/ _ \ '__| '_ \  | | | '_ \| | | \ \/ /
| |  | | (_) | (_| |  __/ |  | | | | | | | | | | |_| |>  < 
|_|  |_|\___/ \__,_|\___|_|  |_| |_| |_|_|_| |_|\__,_/_/\_\
                                                           
      _ _   _              _     
  ___| (_) | |_ ___   ___ | |___ 
 / __| | | | __/ _ \ / _ \| / __|
| (__| | | | || (_) | (_) | \__ \
 \___|_|_|  \__\___/ \___/|_|___/
                                 
```
<!--
---

## "modern" is relative...

**Douglas Adams**

I've come up with a set of rules that describe our reactions to technologies:

> 1. Anything that is in the world **when you're born** is normal and ordinary and is just a natural part of the way the world works.
>
> 2. Anything that's invented **between when you're fifteen and thirty-five** is new and exciting and revolutionary and you can probably get a career in it.
>
> 3. Anything invented **after you're thirty-five** is against the natural order of things.
-->

---

## Target audience

- linux desktop CLI users
- linux admins

```text
  __________________________________________
 / This is the year of linux on the desktop \
|                                            |
|          ...Windows10 has WSL ;-)          |
 \                                          /
  ------------------------------------------
        \   ^__^
         \  (oo)\_______
            (__)\       )\/\
                ||----w |
                ||     ||
```

---

## Linux tooling philosophy

- **do one thing (and only one thing!) well**

- **chaining**

- _sound familiar? (hint: functional programming...)_

---

## Why? Improvements to...

- **productivity**

- **optics**
    - "unix porn" (`PS1`, `ls`, ...)

---

## Learn the basics

- `emacs` and `vim`
    - learn navigation, copy & paste, (and how to exit 👍)
    - pick one and become fluent

- `cd`, `ls`, `cat`, `less`, `find`, `grep`, `sed`, `tail`, `awk`, `dd`, `rsync`, ...
- Combine using pipes ( `|` ) and redirection ( `>` )

---

## terminals and shells

### What is the difference between **terminal** and **shell**?

```text
+--------------------+
|     "terminal"     |
+--------------------+
|                    |
| +--------------+   |
| |              |   |
| |    "shell"   |   |
| |              |   |
| +--------------+   |
|                    |
+--------------------+
```

--

## terminals and shells

### terminal

- **colors** (16 or more), **fonts** (utf8, ligatures, ...)
- **interactions**
    - keyboard shortcuts
    - mouse interaction (copy & paste, scrolling, selection, ...)

### shell

- **everything else** (f.ex. **`PS1`**, scripting language)

--

## terminal

### What is the best terminal?

- use your default

### Unicode, Emojis, Fonts, Image support (!)

- but think about enriching your output!

- Emojis: 👍 ✅ 💥 ✌  💩 💬 🌩 🌟

---

## shell

- bash
- zsh
- fish
- dash (embedded)

--

### shell / zsh

- https://www.zsh.org/

- package manager
    - oh-my-zsh (151k stars) https://ohmyz.sh
- category: shell

--

### shell / fish: The new kid on the block

- https://fishshell.com

- package manager
    - fisher (6.1k stars) https://github.com/jorgebucaran/fisher
    - oh-my-fish (8.8k stars) https://github.com/oh-my-fish/oh-my-fish
- category: shell

--

### shell / bash

- https://www.gnu.org/software/bash/

- package manager
    - bash-it (13.2k stars) https://github.com/Bash-it/bash-it
    - oh-my-bash (3.5k stars) https://ohmybash.github.io
- category: shell

---

### shell / PS1

PS1: alias for "prompt"
- default: `username:/some/location$`
- `$PWD` present working directory

Extra, nice-to-have information
- only show relevant parts (hide user/machine name on local machine)
- compact location ( $PWD )
- git status
- environment infos (node / .NET / Java / Python / etc version)

--

### shell / PS1: liquidprompt

simple prompt

- 4.2k stars https://github.com/nojhan/liquidprompt

- shortens `$PWD`
- adds git status
- available for `zsh`, `bash`, etc
- category: unix-porn

--

### shell / PS1: Powerline

started as fancy statusline for vim …

- 11k stars https://github.com/powerline/powerline

- started as fancy statusline for `vim`...
- shortens `$PWD`
- adds git status
- available for `zsh`, `bash`, etc
- category: unix-porn

--

### shell / PS1: Starship

the new kid on the block

- 16k stars https://github.com/starship/starship

- cross-plattform, cross-shell
- stylish
- great defaults for many environments
- easy to [configure](https://starship.rs/config/)
- category: unix-porn

---

# [Command-Line Operators and What They Do](https://www.makeuseof.com/linux-command-line-chaining-operators/)

--

## Ampersand Operator (&)

```bash
$ sleep 5 &
[1] 301161
```

- command is executed in the background
- shell is freed

--

## Semicolon Operator (;)

```bash
$ pwd; mkdir /tmp/test; cd /tmp/test; touch foo; readlink -f foo
/tmp
/tmp/test/foo
```

- chaining execute commands in a defined, sequential order
- independend from exit code

--

## OR Operator (||)

```bash
$ false || uptime
 11:21:53 up 20 days,  2:30,  1 user,  load average: 0,36, 0,35, 0,46
```

- following command only executed if preceding command fails (exit 0)

--

## Pipe Operator (|)

```bash
$ lspci | grep -E "(Network|Ethernet)"
00:14.3 Network controller: Intel Corporation Comet Lake PCH-LP CNVi WiFi
00:1f.6 Ethernet controller: Intel Corporation Ethernet Connection (10) I219-V
```

- directs output of preceding command as input to succeeding command

--

## AND Operator (&&)

```bash
$ pwd && mkdir /tmp/test && cd /tmp/test && touch foo && readlink -f foo
/tmp/test
mkdir: cannot create directory '/tmp/test': File exists
$ pwd && mkdir -p /tmp/test && cd /tmp/test && touch foo && readlink -f foo
/tmp/test
/tmp/test/foo
```

- following command only executed if preceding command was successfully executed (exit 1)

--

## NOT Operator (!)

```bash
$ ls !(*.txt)
foo
```

- works similar to except statement in programming

--

## Precedence Operator ((..))

```bash
$ (true && false) && (false || true) || echo "Did exit with false"
Did exit with false
```

- used for grouping and precedence of the execution sequence
- inside parentheses, starts [subshell](https://tldp.org/LDP/abs/html/subshells.html#SUBSHELLSREF)

--

## Combination Operator ({..})

```bash
$ [ -f hello.txt ] && echo "file exists" ; echo "hello"
hello
$ [ -f hello.txt ] && { echo "file exists" ; echo "hello"; }
```

- commands are run (or not run) as a whole

--

## Concatenation or the Escape Operator (\\)

```bash
$ echo "Hello! from the\
> other side"
Hello! from theother side
$ touch test\(1\).txt
$ ls test\(1\).txt
'test(1).txt'
```

- concatenate large commands over several lines
- escape character when working with strings

--

## Redirection Operators (>, >>, <)

```bash
$ echo "dsd" > test; echo "bssss" >> test; cat test
dsd
bssss
$ sort < test
bssss
dsd
$ echo "blah" > test; cat test
blah
```

- redirect [stdout](https://en.wikipedia.org/wiki/Standard_streams#Standard_output_(stdout)) or [stdin](https://en.wikipedia.org/wiki/Standard_streams#Standard_input_(stdin))
- Use `2>` to handle [sterr](https://en.wikipedia.org/wiki/Standard_streams#Standard_error_(stderr))

--

## References

- [10 Linux Command-Line Operators and What They Do](https://www.makeuseof.com/linux-command-line-chaining-operators/)
- [Chaining Commands in Linux](https://www.geeksforgeeks.org/chaining-commands-in-linux/)
- [Basics on bash operators](https://lumian2015.github.io/MoreOnLinux/chapter1.html)
- [10 Useful Chaining Operators in Linux with Practical Examples](https://www.tecmint.com/chaining-operators-in-linux-with-practical-examples/)
- [6 Bash Shell Command Line Chaining Operators in Linux](https://www.thegeekdiary.com/6-bash-shell-command-line-chaining-operators-in-linux/)

---

# Tools
## You where waiting for

--

## tldr

- 41k stars https://tldr.sh/

- man pages can be difficult
- tldr: implemented in many languages (js, ruby, python, perl, haskell, etc)
- Demo: `ln`, `tar`, `scp`

--

## McFly

- 4.5 stars https://github.com/cantino/mcfly

- category: history search

> McFly replaces your default `Ctrl R` shell history search with an intelligent search engine that takes into account your working
directory and the context of recently executed commands. McFly’s suggestions are prioritized in real time with a small neural network

--

## thefuck

fix common typos / mistakes

- 51k stars https://github.com/nvbn/thefuck
- example: pushing a newly created git branch
- category: productivity

--

### The GNU Midnight Commander

[mc](http://midnight-commander.org/) is a visual shell much like a file manager, only with many more features
- text mode application, but it also includes mouse support
- best [features](https://www.uibk.ac.at/th-physik/howto/mc.html) are its ability to FTP, view tar and zip files, and to poke into tar, ar, deb, zip, cpio, lha and rar for specific files

--

## bat

`cat` & `less` with syntax highlighting
- 37.6k stars https://github.com/sharkdp/bat

_bat looks good on a dark background by default. However, if your terminal uses a light background, some themes like GitHub or OneHalfLight will work better for you._

- category: read / file display

--

## ripgrep

very fast `grep` replacement <!-- (benchmarks on website) -->
- 33.7k stars https://github.com/BurntSushi/ripgrep
- `ripgrep` recursively searches directories for a regex pattern
- sensible defaults: respect `.gitignore`, ignores hidden files & folders
- command: `rg`
- use `rg hidden g '!.git' "your search"` to search all hidden folder except .git

- category: search

--

## ripgrep-all

ripgrep, but also search in PDFs, E-Books, Office documents, zip, tar.gz, sqlite (!), etc
- 5k stars https://github.com/phiresky/ripgrep-all
- command: `rga`
- faster than `pdfgrep` (see website for a benchmark)
- category: search
- Demo: search in Manning books folder

<!--
cd ~/Dropbox/Apps/Manning\ Books/
rga Vladimir
-->

--

## fzf

interactive fuzzy search
- 47.5k stars https://github.com/junegunn/fzf
- pipe any line based input to fzf: Example `find * -type f | fzf`
- good integration with other tools
- nice helper methods for
    - files & directories `cd **<TAB>`
    - kill `kill -9 <TAB>`
    - host names `ssh **<TAB>`
    - environment variables & aliases `unset **<TAB>`, `export **<TAB>`, `unalias **<TAB>`
- category: search
- Demos:
    - find files and select them
    - search a text file

<!--

cd ~/exercism
## `fzf -m` multiselect
## select files with Shift+TAB
## search for "bob"
find * -type f | fzf -m

cd .
search for  "linux"
cat slides.md | fzf
-->

--

## fd

- 24.9k stars https://github.com/sharkdp/fd

simple alternative to `find`
- "The command name is 50% shorter than `find`"
- Convenient syntax `fd PATTERN` (instead of `find -iname '*PATTERN*'`)
- Sensible defaults: `.gitignore`, ignore hidden files/folders
- fast
- category: search

<!--
# Demo

- TODO
-->

--

## hyperfine

benchmarking tool

- 13.1k stars https://github.com/sharkdp/hyperfine

```bash
# comparing `fd` with `find`

# ubuntu uses `fdfind` by default
hyperfine --warmup 3 'fdfind -HI '.*[0-9]\.jpg$'' 'find ~ -iregex '.*[0-9]\.jpg''

# arch
hyperfine --warmup 3 'fd -HI '.*[0-9]\.jpg$' Documents/talks' 'find Documents/talks -iregex '.*[0-9]\.jpg$''

# unfair comparison: `fd` ignores hidden files and `.git` be default
hyperfine --warmup 3 'fd '.*[0-9]\.jpg$' Documents/talks' 'find Documents/talks -iregex '.*[0-9]\.jpg$''
```
<!--
HYPERFINE_VERSION=$(curl -s "https://api.github.com/repos/sharkdp/hyperfine/releases/latest" | grep -Po '"tag_name": "v\K[0-9.]+')
curl -Lso /tmp/hyperfine.deb "https://github.com/sharkdp/hyperfine/releases/latest/download/hyperfine_${HYPERFINE_VERSION}_amd64.deb"
sudo apt install -y /tmp/hyperfine.deb
-->
- category: benchmarking

--

## progress

monitor any kind of "copy"

- 5.8k stars https://github.com/Xfennec/progress
- attach to any kind of copy
- category: monitoring

```sh
No command currently running: cp, mv, dd, tar, cat, rsync, grep, fgrep, egrep, cut, sort, md5sum,
sha1sum, sha224sum, sha256sum, sha384sum, sha512sum, adb, gzip, gunzip, bzip2, bunzip2, xz,
unxz, lzma, unlzma, 7z, 7za, zcat, bzcat, lzcat, split, gpg, or wrong permissions.
```

- Demo:
    - `~/tmp/demo/origin/` contains very large file
    - tmux split screen `~/tmp/demo/`
    - copy from `~/tmp/demo/origin/*` to `~/tmp/demo/destination/` using `cp`.
    - `watch progress`

--

## Ultimate Plumber (up)

interactive REPL (read–eval–print loop) for shell piping

- 7.8k stars https://github.com/akavel/up

- interactive piping
- instant live preview
- category: search, file manipulation, interactive

- Demo: images/up-demo.gif

<!--
curl -Lso ~/bin/up "https://github.com/akavel/up/releases/latest/download/up" && chmod +x ~/bin/up
-->

--

## lolcat

Rainbows and unicorns

- 5.2k stars https://github.com/busyloop/lolcat
- category: fun, unix porn

--

## ttyd

- 4.4 stars https://tsl0922.github.io/ttyd/

```text
            _ ._  _ , _ ._
          (_ ' ( `  )_  .__)
        ( (  (    )   `)  ) _)
       (__ (_   (_ . _) _) ,__)
           `~~`\ ' . /`~~`
           ,::: ;   ; :::,
          ':::::::::::::::'
 ______________/_ __ \_____________
|                                  |
|               ttyd               |
| share your terminal over the web |
|__________________________________|
```

- category: network, dangerous

<!--
echo -e "ttyd\nshare your terminal over the web" | boxes -d nuke -a c
-->

--

## sl

typo `sl` (instead of `ls`) -> show steam locomotive

- 2.5k stars https://github.com/mtoyoda/sl

- category: fun, unix porn


--

## patat

- 1.9k stars https://github.com/jaspervdj/patat

- nerdy slides in your shell
- runs in a terminal (similar to `revealJs` for the browser)
- Pandoc syntax (f. ex. markdown)
- syntax highlighting

```javascript
let foo = "bar";
```
<!--
- emojis: :thumbsup:, :white_check_mark:, :ballot_box_with_check:, :collision:
-->
- next slide: experimental image support in some terminals (same as for `ranger`)
    - `iterm2`, `urxvt`, `kitty`

- category: presentation, slides, unix porn

--

## ls on steroids

`ls` problem: sort by name and time at the same time...

**Use colors!**

- `colorls` ("the original" in ruby: https://github.com/athityakumar/colorls)
- `lsd` (in rust: https://github.com/Peltoche/lsd)
- `exa` (in rust: https://github.com/ogham/exa)

Required: font providing all symbols

- Example: NerdFonts https://github.com/ryanoasis/nerd-fonts

--

## ncdu

- https://dev.yorhel.nl/ncdu

- interactive `df` alternative

---

# Making Connections

## [the serial way](https://wiki.archlinux.org/title/working_with_the_serial_console#Making_Connections)

--

## terminal

```
$ picocom -b 115200 /dev/ttyUSB0
$ screen /dev/ttyUSB0 115200
$ minicom -s -D /dev/ttyUSB0
```

[More serial p0rn](https://vmandela.com/blog/2019/2019-05-28-serial-port-tools.html)

--

## grafical

- cutecom
- moserial
- PuTTY

--

## Windows

- [PuTTY](https://www.chiark.greenend.org.uk/~sgtatham/putty/download.html)
- [Terminalbpp](https://sites.google.com/site/terminalbpp/)

---

## monitoring

- htop
- apachetop
- ngxtop
- mtp
- pg_top
- powertop
- iotop
- iftop
- nethogs

---

## Some more tools

- mosh (robust replacement for ssh) https://mosh.org/
- neofetch (fancy system info in the shell) 7.7k stars https://github.com/dylanaraps/neofetch 
- expect https://likegeeks.com/expect-command/
- jq (sed for json) https://stedolan.github.io/jq/
- httpie (cli http client) 45k stars https://httpie.org/
- http-prompt (cli http client) 7.6k stars http://http-prompt.com/
- pywal (color schemes for terminal) 3.4k stars https://github.com/dylanaraps/pywal
- fish_config (web-based configuration tool for fish shell) https://fishshell.com/docs/current/commands.html#fish_config
- xclip (cli to X clipboard) 403 stars https://github.com/astrand/xclip
- apt-iselect (interactive ncurses package search for debian) https://www.rot13.org/~dpavlin/apt-iselect.html
- gcalcli (google calender in the shell) 2k stars https://github.com/insanum/gcalcli
- pastebinit (cli tool to send data to pastebin) 17 stars https://github.com/skorokithakis/pastebinit
- MapSCII (ascii google maps in the terminal) https://github.com/rastapasta/mapscii
- alwaysontop (always move prompt to top of screen) 160 stars https://github.com/swirepe/alwaysontop

<!--
echo -e "did I miss your favorite tool?" | boxes -d girl -a c
-->

---

# Bonus: CLI murder mystery

- 3.8k stars https://github.com/veltman/clmystery

- CLI murder mystery
