#!/bin/bash
DOCKER_BASE=/srv/docker

mkdir -p ${DOCKER_BASE}/watchtower/container.conf

cat > ${DOCKER_BASE}/watchtower/container.conf/docker-compose.yml <<EOF
version: '3.3'

services:
  watchtower:
    image: v2tec/watchtower
    labels:
      com.centurylinklabs.watchtower.enable: "true"
    restart: on-failure
    volumes:
      - /var/run/docker.sock:/var/run/docker.sock
    command: --interval 3600 --label-enable
EOF
ln -s container.conf/docker-compose.yml ${DOCKER_BASE}/watchtower/

cat > ${DOCKER_BASE}/watchtower/container.conf/watchtower.service <<EOF
[Unit]
Description=Watchtower Service
After=network.target docker.service
Requires=docker.service

[Service]
Type=oneshot                                                                    
RemainAfterExit=yes

Environment="WORK_DIR=/srv/docker/watchtower/"
WorkingDirectory=/srv/docker/watchtower/
ExecStartPre=-/usr/local/bin/docker-compose -f "\${WORK_DIR}/docker-compose.yml" down
ExecStartPre=-/usr/local/bin/docker-compose -f "\${WORK_DIR}/docker-compose.yml" pull
ExecStart=/usr/local/bin/docker-compose -f "\${WORK_DIR}/docker-compose.yml" up -d
ExecStop=/usr/local/bin/docker-compose -f "\${WORK_DIR}/docker-compose.yml" down 

[Install]
WantedBy=docker.service
EOF
ln -s ${DOCKER_BASE}/watchtower/container.conf/watchtower.service /etc/systemd/system/

systemctl daemon-reload && systemctl enable watchtower && systemctl start watchtower