#!/bin/bash
DOCKER_BASE=/srv/docker
WATCHTOWER_PATH=${DOCKER_BASE}/watchtower
DC_COMMAND="docker-compose -f docker-compose.yml"

cd ${WATCHTOWER_PATH} || exit
[ -f container.conf/production.yml ] && DC_COMMAND="${DC_COMMAND} -f container.conf/production.yml"
[ "$(${DC_COMMAND} config | grep "WATCHTOWER_NOTIFICATIONS" | awk '{print $2}')" != "email" ] && exit
cp container.conf/production.yml container.conf/production.yml.old

SMTP_HOST="$(${DC_COMMAND} config | grep "WATCHTOWER_NOTIFICATION_EMAIL_SERVER:" | awk '{print $2}')"
SMTP_FROM="$(${DC_COMMAND} config | grep "WATCHTOWER_NOTIFICATION_EMAIL_FROM:" | awk '{print $2}')"
SMTP_TO="$(${DC_COMMAND} config | grep "WATCHTOWER_NOTIFICATION_EMAIL_TO:" | awk '{print $2}')"

[ ! -e ${WATCHTOWER_PATH}/.env ] && ln -s container.conf/.env ${WATCHTOWER_PATH}/.env
touch ${WATCHTOWER_PATH}/container.conf/.env
sed -iE '/^SMTP_/d' ${WATCHTOWER_PATH}/container.conf/.env
cat >> ${WATCHTOWER_PATH}/container.conf/.env <<EOF
SMTP_HOST=${SMTP_HOST}
SMTP_FROM=${SMTP_FROM}
SMTP_TO=${SMTP_TO}
EOF

sed -i 's/WATCHTOWER_NOTIFICATIONS.*email/WATCHTOWER_NOTIFICATIONS=shoutrrr/' ${WATCHTOWER_PATH}/container.conf/production.yml
sed -i 's#WATCHTOWER_NOTIFICATION_EMAIL_FROM.*"#WATCHTOWER_NOTIFICATION_URL=smtp://:@\${SMTP_HOST}/?auth=None\&encryption=None\&fromaddress=\${SMTP_FROM}\&fromname=Watchtower\&starttls=No\&toaddresses=\${SMTP_TO}\&usehtml=No"#' ${WATCHTOWER_PATH}/container.conf/production.yml
sed -iE '/WATCHTOWER_NOTIFICATION_EMAIL_/d' ${WATCHTOWER_PATH}/container.conf/production.yml
