#!/bin/bash
DOCKER_BASE=/srv/docker

mkdir -p ${DOCKER_BASE}/watchtower/container.conf

[ $(grep -c "healthcheck:" ${DOCKER_BASE}/watchtower/container.conf/production.yml) -eq 0 ] && sed -i '/labels:/i\    healthcheck:\n\      test: ["CMD", "/watchtower", "--health-check"]\n\      interval: 30s\n\      timeout: 10s\n\      retries: 3\n\      start_period: 40s' ${DOCKER_BASE}/watchtower/container.conf/docker-compose.yml && cd ${DOCKER_BASE}/watchtower/ && docker-compose -f docker-compose.yml -f container.conf/production.yml config && systemctl restart watchtower
