#!/bin/bash
DOCKER_BASE=/srv/docker

mkdir -p ${DOCKER_BASE}/portainer/container.conf

cat > ${DOCKER_BASE}/portainer/container.conf/docker-compose.yml <<EOF
version: '3.7'
services:
  portainer:
    image: portainer/portainer
    command: --no-analytics
    networks:
      - default
      - traefik_default
    labels:
      - traefik.enable=true
      - traefik.backend=portainer
      - traefik.docker.network=traefik_default
      - traefik.port=9000
      - traefik.default.protocol=http
    restart: always
    volumes:
      - /srv/docker/portainer/data:/data
      - /var/run/docker.sock:/var/run/docker.sock
      - /etc/localtime:/etc/localtime:ro
      - /etc/timezone:/etc/timezone:ro

networks:
  traefik_default:
    external: true
EOF
ln -s container.conf/docker-compose.yml ${DOCKER_BASE}/portainer/

cat > ${DOCKER_BASE}/portainer/container.conf/production.yml <<EOF
version: '3.7'

services:

  portainer:
    labels:
      # https://github.com/containous/traefik/issues/563#issuecomment-421360934
      - "traefik.frontend.redirect.regex=^(.*)/ui\$\$"
      - "traefik.frontend.redirect.replacement=\$\$1/ui/"
      - "traefik.frontend.rule=Host:host.test.org;PathPrefix:/ui;ReplacePathRegex: ^/ui/(.*) /\$\$1"
      - com.centurylinklabs.watchtower.enable=true
EOF

cat > ${DOCKER_BASE}/portainer/container.conf/portainer.service <<EOF
[Unit]
Description=Portainer Service                                                   
After=network.target docker.service traefik.service                             
Requires=docker.service  

[Service]
Type=oneshot
RemainAfterExit=yes

Environment="WORK_DIR=/srv/docker/portainer/"
WorkingDirectory=/srv/docker/portainer/
ExecStartPre=-/usr/local/bin/docker-compose -f "\${WORK_DIR}/docker-compose.yml" -f "\${WORK_DIR}/container.conf/production.yml" down
ExecStart=/usr/local/bin/docker-compose -f "\${WORK_DIR}/docker-compose.yml" -f "\${WORK_DIR}/container.conf/production.yml" up -d
ExecStop=/usr/local/bin/docker-compose -f "\${WORK_DIR}/docker-compose.yml" -f "\${WORK_DIR}/container.conf/production.yml" down

[Install]
WantedBy=docker.service
EOF
ln -s ${DOCKER_BASE}/portainer/container.conf/portainer.service /etc/systemd/system/

systemctl daemon-reload && systemctl enable portainer && systemctl start portainer
