#!/bin/sh
MYSQLADMIN_CFG="/etc/mysql/mariadb.conf.d/90-mysqladmin.cnf"
# generate password
PASS=$(perl -e 'print map{("a".."z","A".."Z",0..9)[int(rand(62))]}(1..16)');
# create config file
umask 066
cat > ${MYSQLADMIN_CFG} <<EOF
[mysqladmin]
host     = localhost
user     = debian-sys-maint
password = ${PASS}
socket   = /var/run/mysqld/mysqld.sock 
EOF
umask 022
chown 0:0 ${MYSQLADMIN_CFG}; chmod 0600 ${MYSQLADMIN_CFG}
# update credentials
mysql -u root -p -e "GRANT ALL ON *.* TO 'debian-sys-maint'@'localhost' IDENTIFIED BY '${PASS}' WITH GRANT OPTION;"