#!/bin/bash
# wget https://gist.githubusercontent.com/waja/d0995072b54b4ab5cb2b5e9ab9962543/raw/deploy_icinga2_agent_hw.sh -O /tmp/b && bash /tmp/b

. /etc/os-release

if [ "$(systemd-detect-virt)" == "none" ]; then
	modprobe ipmi_si && modprobe ipmi_devintf && \
	 apt-get install -y --no-install-recommends -t ${VERSION_CODENAME}-backports freeipmi-tools libipc-run-perl pciutils && \
	 echo "nagios ALL=(root) NOPASSWD: /usr/sbin/ipmi-sensors, /usr/sbin/ipmi-sel, /usr/sbin/ipmi-fru, /usr/sbin/ipmi-dcmi" > /etc/sudoers.d/check_ipmi_sensor && \
	 echo "ipmi_devintf" >> /etc/modules && echo "ipmi_si" >> /etc/modules
	apt-get install -y --no-install-recommends -t ${VERSION_CODENAME}-backports nagios-plugins-contrib sudo && \
	if [ -f /proc/mdstat ]; then
		cat > /etc/sudoers.d/check_raid <<EOF
User_Alias CHECK_RAID=nagios
Defaults:CHECK_RAID !requiretty
CHECK_RAID ALL=(root) NOPASSWD: /sbin/dmsetup status --noflush
EOF
        elif [[ "$(lspci | grep MegaRAID)" == *"MegaRAID"* ]]; then
		if [ ${VERSION_ID} -gt 11 ]; then
			VERSION_CODENAME="bullseye"
		fi
		cat > /etc/apt/sources.list.d/${VERSION_CODENAME}-le-vert.net.list <<EOF
# Add key: wget -O - http://hwraid.le-vert.net/debian/hwraid.le-vert.net.gpg.key | sudo apt-key add -
#

#
# Packages for RAID systems (http://hwraid.le-vert.net/wiki/DebianPackages)
#

deb http://hwraid.le-vert.net/debian ${VERSION_CODENAME} main
EOF
		wget -O - http://hwraid.le-vert.net/debian/hwraid.le-vert.net.gpg.key | sudo apt-key add - && \
		 apt-get update && \
		 apt-get install -y --no-install-recommends megacli sudo && \
		cat > /etc/sudoers.d/check_raid <<EOF
User_Alias CHECK_RAID=nagios, icinga, sensu
Defaults:CHECK_RAID !requiretty
CHECK_RAID ALL=(root) NOPASSWD: /sbin/dmsetup status --noflush
CHECK_RAID ALL=(root) NOPASSWD: /sbin/megacli -PDList -aALL -NoLog
CHECK_RAID ALL=(root) NOPASSWD: /sbin/megacli -LdInfo -Lall -aALL -NoLog
CHECK_RAID ALL=(root) NOPASSWD: /sbin/megacli -AdpBbuCmd -GetBbuStatus -aALL -NoLog
EOF
	fi
fi
