#!/bin/bash
if [ "$(systemd-detect-virt)" == "none" ]; then
	apt-get install -y --no-install-recommends -t $(lsb_release -sc)-backports nagios-plugins-contrib freeipmi-tools libipc-run-perl && \ 
	 echo "nagios ALL=(root) NOPASSWD: /usr/sbin/ipmi-sensors, /usr/sbin/ipmi-sel, /usr/sbin/ipmi-fru, /usr/sbin/ipmi-dcmi" > /etc/sudoers.d/check_ipmi_sensor && \
	 modprobe ipmi_si && modprobe ipmi_devintf && \
	 echo "ipmi_devintf" >> /etc/modules && echo "ipmi_si" >> /etc/modules
	if [ -f /proc/mdstat ]; then
		cat > /etc/sudoers.d/check_raid <<EOF
User_Alias CHECK_RAID=nagios
Defaults:CHECK_RAID !requiretty
CHECK_RAID ALL=(root) NOPASSWD: /sbin/dmsetup status --noflush
EOF
        elif [[ "$(lspci | grep MegaRAID)" == *"MegaRAID"* ]]; then
		cat > /etc/apt/sources.list.d/$(lsb_release -sc)-le-vert.net.list <<EOF
# Add key: wget -O - http://hwraid.le-vert.net/debian/hwraid.le-vert.net.gpg.key | sudo apt-key add -
#

#
# Packages for RAID systems (http://hwraid.le-vert.net/wiki/DebianPackages)
#

deb http://hwraid.le-vert.net/debian $(lsb_release -sc) main
EOF
		wget -O - http://hwraid.le-vert.net/debian/hwraid.le-vert.net.gpg.key | sudo apt-key add - && \
		 apt-get update && \
		 apt-get install -y --no-install-recommends megacli sudo && \
		cat > /etc/sudoers.d/check_raid <<EOF
User_Alias CHECK_RAID=nagios, icinga, sensu
Defaults:CHECK_RAID !requiretty
CHECK_RAID ALL=(root) NOPASSWD: /sbin/dmsetup status --noflush
CHECK_RAID ALL=(root) NOPASSWD: /sbin/megacli -PDList -aALL -NoLog
CHECK_RAID ALL=(root) NOPASSWD: /sbin/megacli -LdInfo -Lall -aALL -NoLog
CHECK_RAID ALL=(root) NOPASSWD: /sbin/megacli -AdpBbuCmd -GetBbuStatus -aALL -NoLog
EOF
	fi
fi
