#!/bin/bash
# Install docker compose
apt-get install docker-compose-plugin
# Install docker compsoe switch
SWITCH_VER=$(curl -s -o /dev/null -I -w "%{redirect_url}\n" https://github.com/docker/compose-switch/releases/latest | grep -oP "[0-9]+(\.[0-9]+)+$") && \
curl -sSL https://github.com/docker/compose-switch/releases/download/v$SWITCH_VER/docker-compose-linux-amd64 -o /usr/local/bin/compose-switch && chmod +x /usr/local/bin/compose-switch && \
# Move old docker-compose v1 binary away
if [ -f /usr/local/bin/docker-compose ]; then
	if [ $(/usr/local/bin/docker-compose version | head -1 | grep -oP "[0-9]+(\.[0-9]+)+" | grep -c "^1") == 1 ]; then
		mv /usr/local/bin/docker-compose /usr/local/bin/docker-compose-v1;
	fi;
fi && \
# Update alternative
if [ ! -L /usr/local/bin/docker-compose ]; then
	[ -f /usr/local/bin/compose-switch ] && update-alternatives --install /usr/local/bin/docker-compose docker-compose /usr/local/bin/compose-switch 99 && \
	[ -f /usr/local/bin/docker-compose-v1 ] && update-alternatives --install /usr/local/bin/docker-compose docker-compose /usr/local/bin/docker-compose-v1
fi;
# Install ctop
echo "deb http://packages.azlux.fr/debian/ buster main" | tee /etc/apt/sources.list.d/azlux.list && \
if [ -d /etc/apt/trusted.gpg.d/ ]; then curl -fsSL https://azlux.fr/repo.gpg.key | sudo gpg --batch --yes --dearmor -o /etc/apt/trusted.gpg.d/azlux.gpg; else curl -fsSL https://azlux.fr/repo.gpg.key | sudo apt-key add -; fi && \
apt update && \
apt install docker-ctop && \
# Install lazydocker
curl -so /tmp/deploy_lazydocker.sh https://gist.githubusercontent.com/waja/be393038c754cff65d58850c1131d938/raw/deploy_lazydocker.sh && \
bash /tmp/deploy_lazydocker.sh && \
[ -f /usr/local/bin/ctop ] && rm -rf /usr/local/bin/ctop || exit 0 \
