#!/bin/bash
# detect release and add package sources
[ "$(lsb_release -rs)" = "testing" ] || [ "$(cat /etc/debian_version | awk -F. {'print $1'})" -ne "8" ] && echo exit 1
echo "deb [arch=amd64] https://download.docker.com/linux/debian $(lsb_release -cs) stable" > \
  /etc/apt/sources.list.d/$(lsb_release -cs)-docker.list && \
# Install needed dependencies
  apt-get install -y apt-transport-https ca-certificates bridge-utils curl sudo && \
  if [ -d /etc/apt/trusted.gpg.d/ ]; then curl -fsSL https://download.docker.com/linux/debian/gpg | sudo gpg --dearmor -o /etc/apt/trusted.gpg.d/docker-archive-keyring.gpg; else apt-key adv --keyserver keyserver.ubuntu.com --recv-keys 0EBFCD88; fi && \
apt-get update; \
# Deploy pinning and unatteded upgrade config for docker-ce and container.io
# yes, we can do 'curl pipe bash', but this way we can adjust the script if something failes without redownload it
curl -o /tmp/autoupgrade_docker-ce_container.io.sh https://gist.githubusercontent.com/waja/01ba2641f93f461044f9/raw/autoupgrade_docker-ce_container.io.sh && \
bash /tmp/autoupgrade_docker-ce_container.io.sh && \
# Install docker and enable it
apt-get install -y docker-ce && \
systemctl enable docker && \
# Allow to relay from local networks (where our containers are running)
sed -i 's#127.0.0.0/8#127.0.0.0/8 10.0.0.0/8 172.16.0.0/12 192.168.0.0/16#' /etc/postfix/main.cf && \
service postfix reload && \
# https://gist.github.com/steakknife/9094991#file-run_me_001__install_docker_and_fixes-sh-L20-L22 (enable swap resource limiting)
# https://tianon.github.io/post/2017/05/18/docker-setup-redux.html#configure-boot-parameters
[ -x /usr/sbin/update-grub ] && \
sed -i 's/\(GRUB_CMDLINE_LINUX_DEFAULT="quiet\)"/\1 cgroup_enable=memory swapaccount=1 systemd.legacy_systemd_cgroup_controller=yes vsyscall=emulate"/' /etc/default/grub && \
update-grub; \
# Enable live restore (https://docs.docker.com/config/containers/live-restore/)
cat > /etc/docker/daemon.json <<EOF
{
  "live-restore": true
}
EOF
# Install docker-compose and ctop
curl -o /tmp/deploy_addons.sh https://gist.githubusercontent.com/waja/01ba2641f93f461044f9/raw/deploy_addons.sh && \
bash /tmp/deploy_addons.sh && \
# Blacklist container.io for needsrestart
[ -d /etc/needrestart/conf.d/ -a ! -f /etc/needrestart/conf.d/blacklist_rc.conf ] && \
cat > /etc/needrestart/conf.d/blacklist_rc.conf <<EOF
\$nrconf{blacklist_rc} = [
        qr(containerd.service),
];
EOF
# Add some cleanup jobs
cat > /etc/cron.weekly/docker-cleanup <<EOF
#!/bin/bash
# See https://getintodevops.com/blog/keeping-the-whale-happy-how-to-clean-up-after-docker
# DELETE STOPPED CONTAINERS, AND VOLUMES AND NETWORKS THAT ARE NOT USED BY CONTAINERS
# docker system prune -a -f
# DELETE EXITED CONTAINERS
# docker container ps -aqf status=exited && docker container rm $(docker container ps -aqf status=exited)
# DELETE DANGLING AND UNTAGGED IMAGES
# docker images -q -f dangling=true && docker image rm $(docker images -q -f dangling=true)
# DELETE ORPHANED AND DANGLING VOLUMES
DOCKER_VOLUMES=\$(docker volume ls -qf dangling=true)
if [ "\${DOCKER_VOLUMES}" != "" ]; then
	docker volume rm \${DOCKER_VOLUMES}
fi
# garbage collection, see https://github.com/spotify/docker-gc/blob/master/README.md 
docker run --rm -v /var/run/docker.sock:/var/run/docker.sock -v /etc:/etc:ro -e MINIMUM_IMAGES_TO_SAVE=2 -e GRACE_PERIOD_SECONDS=432000 spotify/docker-gc | grep -v running
EOF
chmod +x /etc/cron.weekly/docker-cleanup
# To update pinning, unattended upgrade config and updating docker compose, ctop and lazydocker
# curl -o /tmp/autoupgrade_docker-ce_container.io.sh https://gist.githubusercontent.com/waja/01ba2641f93f461044f9/raw/autoupgrade_docker-ce_container.io.sh && bash /tmp/autoupgrade_docker-ce_container.io.sh && curl -o /tmp/deploy_addons.sh https://gist.githubusercontent.com/waja/01ba2641f93f461044f9/raw/deploy_addons.sh && bash /tmp/deploy_addons.sh
