#!/bin/bash
[ "$(cat /etc/debian_version | awk -F. {'print $1'})" -ne "8" ] && echo exit 1
echo "deb https://download.docker.com/linux/debian $(lsb_release -cs) stable" > \
  /etc/apt/sources.list.d/docker.list && \
apt-key adv --keyserver keyserver.ubuntu.com --recv-keys 0EBFCD88; \
aptitude install -y apt-transport-https ca-certificates bridge-utils; \
aptitude update; \
aptitude install -y docker-ce && \
update-rc.d docker enable && \
# https://gist.github.com/steakknife/9094991#file-run_me_001__install_docker_and_fixes-sh-L20-L22 (enable swap resource limiting)
sed -i 's/\(GRUB_CMDLINE_LINUX_DEFAULT="quiet\)"/\1 swapaccount=1"/' /etc/default/grub && \
update-grub && \
cat > /etc/cron.weekly/docker-cleanup <<EOF
#!/bin/bash
# See https://getintodevops.com/blog/keeping-the-whale-happy-how-to-clean-up-after-docker
# DELETE STOPPED CONTAINERS, AND VOLUMES AND NETWORKS THAT ARE NOT USED BY CONTAINERS
# docker system prune -a -f
# DELETE EXITED CONTAINERS
# docker container ps -aqf status=exited && docker container rm $(docker container ps -aqf status=exited)
# DELETE DANGLING AND UNTAGGED IMAGES
# docker images -q -f dangling=true && docker image rm $(docker images -q -f dangling=true)
# DELETE ORPHANED AND DANGLING VOLUMES
docker volume ls -qf dangling=true && docker volume rm $(docker volume ls -qf dangling=true)
EOF
chmod +x /etc/cron.weekly/docker-cleanup