#!/bin/bash
# Install docker-compose and bash completion
COMPOSE_VER=$(curl -s -o /dev/null -I -w "%{redirect_url}\n" https://github.com/docker/compose/releases/latest | grep -oP "[0-9]+(\.[0-9]+)+$") && \
curl -o /usr/local/bin/docker-compose -L https://github.com/docker/compose/releases/download/$COMPOSE_VER/docker-compose-$(uname -s)-$(uname -m) && \
[ -d /etc/bash_completion.d/ ] || mkdir -p /etc/bash_completion.d/ && \
curl -L https://raw.githubusercontent.com/docker/compose/${COMPOSE_VER}/contrib/completion/bash/docker-compose > /etc/bash_completion.d/docker-compose && \
chmod +x /usr/local/bin/docker-compose && \
# Install ctop
CTOP_VER=$(curl -s -o /dev/null -I -w "%{redirect_url}\n" https://github.com/bcicen/ctop/releases/latest | grep -oP "[0-9]+(\.[0-9]+)+$") && \
curl -o /usr/local/bin/ctop -L https://github.com/bcicen/ctop/releases/download/v$CTOP_VER/ctop-$CTOP_VER-$(uname -s|tr '[:upper:]' '[:lower:]')-$(dpkg --print-architecture) && \
chmod +x /usr/local/bin/ctop && \
# Install lazydocker
curl -o /tmp/deploy_lazydocker.sh https://gist.githubusercontent.com/waja/be393038c754cff65d58850c1131d938/raw/deploy_lazydocker.sh && \
bash /tmp/deploy_lazydocker.sh
