#!/bin/bash
# Install docker-compose and bash completion
COMPOSE_VER=$(curl -s -o /dev/null -I -w "%{redirect_url}\n" https://github.com/docker/compose/releases/latest | grep -oP "[0-9]+(\.[0-9]+)+$") && \
curl -o /usr/local/bin/docker-compose -L https://github.com/docker/compose/releases/download/$COMPOSE_VER/docker-compose-$(uname -s)-$(uname -m) && \
[ -d /etc/bash_completion.d/ ] || mkdir -p /etc/bash_completion.d/ && \
curl -L https://raw.githubusercontent.com/docker/compose/${COMPOSE_VER}/contrib/completion/bash/docker-compose > /etc/bash_completion.d/docker-compose && \
chmod +x /usr/local/bin/docker-compose && \
# Install ctop
echo "deb http://packages.azlux.fr/debian/ buster main" | tee /etc/apt/sources.list.d/azlux.list && \
if [ -d /etc/apt/trusted.gpg.d/ ]; then curl -fsSL https://azlux.fr/repo.gpg.key | sudo gpg --dearmor -o /etc/apt/trusted.gpg.d/azlux.gpg; else curl -fsSL https://azlux.fr/repo.gpg.key | sudo apt-key add -; fi && \
apt update && \
apt install docker-ctop && \
# Install lazydocker
curl -o /tmp/deploy_lazydocker.sh https://gist.githubusercontent.com/waja/be393038c754cff65d58850c1131d938/raw/deploy_lazydocker.sh && \
bash /tmp/deploy_lazydocker.sh && \
[ -f /usr/local/bin/ctop ] && rm -rf /usr/local/bin/ctop || exit 0 \
