#!/bin/bash
[ "$(cat /etc/debian_version | awk -F. {'print $1'})" -ne "8" ] && echo exit 1
echo "deb https://apt.dockerproject.org/repo debian-jessie main" > \
  /etc/apt/sources.list.d/docker.list && \
apt-key adv --keyserver keyserver.ubuntu.com --recv-keys F76221572C52609D; \
aptitude install -y apt-transport-https ca-certificates bridge-utils; \
aptitude update; \
aptitude install -y docker-engine && \
update-rc.d docker enable && \
sed -i 's/^allow-hotplug eth0/#allow-hotplug eth0/g' /etc/network/interfaces;\
sed -i 's/^iface eth0 inet/#iface eth0 inet/' /etc/network/interfaces; \
echo -e "auto br0\niface br0 inet dhcp\n\tbridge_ports eth0\n\tbridge_fd 0\n\tbridge_hello 0\n\tbridge_maxwait 0\n\tbridge_stp off" > /etc/network/interfaces.d/br0_eth0.conf; \
sed -i '/^#DOCKER_OPTS.*/aDOCKER_OPTS="-b br0"' /etc/default/docker