#!/bin/bash
# detect release and add package sources
[ "$(lsb_release -rs)" = "testing" ] || [ "$(cat /etc/debian_version | awk -F. {'print $1'})" -ne "8" ] && echo exit 1
echo "deb [arch=amd64] https://download.docker.com/linux/debian $(lsb_release -cs) stable" > \
  /etc/apt/sources.list.d/$(lsb_release -cs)-docker.list && \
apt-key adv --keyserver keyserver.ubuntu.com --recv-keys 0EBFCD88; \
# Install needed dependencies
aptitude install -y apt-transport-https ca-certificates bridge-utils curl; \
aptitude update; \
# Install docker and enable it
aptitude install -y docker-ce && \
systemctl enable docker && \
# Allow to relay from local networks (where our containers are running)
sed -i 's#127.0.0.0/8#127.0.0.0/8 10.0.0.0/8 172.16.0.0/12 192.168.0.0/16#' /etc/postfix/main.cf && \
service postfix reload && \
# https://gist.github.com/steakknife/9094991#file-run_me_001__install_docker_and_fixes-sh-L20-L22 (enable swap resource limiting)
# https://tianon.github.io/post/2017/05/18/docker-setup-redux.html#configure-boot-parameters
[ -x /usr/sbin/update-grub ] && \
sed -i 's/\(GRUB_CMDLINE_LINUX_DEFAULT="quiet\)"/\1 cgroup_enable=memory swapaccount=1 systemd.legacy_systemd_cgroup_controller=yes vsyscall=emulate"/' /etc/default/grub && \
update-grub; \
# Install docker-compose and bash completion
COMPOSE_VER=$(curl -s -o /dev/null -I -w "%{redirect_url}\n" https://github.com/docker/compose/releases/latest | grep -oP "[0-9]+(\.[0-9]+)+$") && \
curl -o /usr/local/bin/docker-compose -L https://github.com/docker/compose/releases/download/$COMPOSE_VER/docker-compose-$(uname -s)-$(uname -m) && \
[ -d /etc/bash_completion.d/ ] || mkdir -p /etc/bash_completion.d/ && \
curl -L https://raw.githubusercontent.com/docker/compose/${COMPOSE_VER}/contrib/completion/bash/docker-compose > /etc/bash_completion.d/docker-compose && \
chmod +x /usr/local/bin/docker-compose && \
# Add some cleanup jobs
cat > /etc/cron.weekly/docker-cleanup <<EOF
#!/bin/bash
# See https://getintodevops.com/blog/keeping-the-whale-happy-how-to-clean-up-after-docker
# DELETE STOPPED CONTAINERS, AND VOLUMES AND NETWORKS THAT ARE NOT USED BY CONTAINERS
# docker system prune -a -f
# DELETE EXITED CONTAINERS
# docker container ps -aqf status=exited && docker container rm $(docker container ps -aqf status=exited)
# DELETE DANGLING AND UNTAGGED IMAGES
# docker images -q -f dangling=true && docker image rm $(docker images -q -f dangling=true)
# DELETE ORPHANED AND DANGLING VOLUMES
DOCKER_VOLUMES=\$(docker volume ls -qf dangling=true)
if [ "\${DOCKER_VOLUMES}" != "" ]; then
	docker volume rm \${DOCKER_VOLUMES}
fi
# garbage collection, see https://github.com/spotify/docker-gc/blob/master/README.md 
docker run --rm -v /var/run/docker.sock:/var/run/docker.sock -v /etc:/etc:ro -e MINIMUM_IMAGES_TO_SAVE=2 -e GRACE_PERIOD_SECONDS=432000 spotify/docker-gc | grep -v running
EOF
chmod +x /etc/cron.weekly/docker-cleanup
