#!/bin/bash
# depends on https://gist.github.com/waja/01ba2641f93f461044f9
[ "$(cat /etc/debian_version | awk -F. {'print $1'})" -ne "8" ] && echo exit 1
cat >/etc/apt/sources.list.d/runner_gitlab-ci-multi-runner.list <<EOF
# this file was generated by packages.gitlab.com for
# the repository at https://packages.gitlab.com/runner/gitlab-ci-multi-runner

deb https://packages.gitlab.com/runner/gitlab-ci-multi-runner/debian/ jessie main
deb-src https://packages.gitlab.com/runner/gitlab-ci-multi-runner/debian/ jessie main
EOF
wget -O - https://packages.gitlab.com/gpg.key | apt-key add -
aptitude update; aptitude install gitlab-ci-multi-runner
cat >/etc/cron.daily/gitlab-ci_clean_orphaned_docker_images <<EOF
#!/bin/bash
for i in $(docker ps -a | grep "weeks ago" | cut -f1 -d" "); do docker stop $i && docker rm $i; done
EOF
chmod +x /etc/cron.daily/gitlab-ci_clean_orphaned_docker_images