#!/bin/bash

[ -f /etc/dehydrated/hook.sh ] && . /etc/dehydrated/hook.sh

SASLDBFILE="/var/spool/postfix/etc/sasldb2"
SASLDBPASSWD="$(/usr/bin/which saslpasswd2)"
SASLDBLISTUSER="$(/usr/bin/which sasldblistusers2)"
LOGFILE="/var/log/sasl/createsasluser.log"
RSYNC="$(/usr/bin/which rsync)"
PWGEN="$(/usr/bin/which pwgen)"
DEFAULTDOMAIN="$(head -1 /etc/dehydrated/domains.txt | awk {'print $1'})"
SYNC="1"

while [[ ! ${USERNAME} || -z "${USERNAME}" ]]; do
        read -p 'Username: ' USERNAME
done
while [[ ! ${DOMAIN} || -z "${DOMAIN}" ]]; do
        read -e -i "${DEFAULTDOMAIN}" -p "Domain: " DOMAIN
        DOMAIN=${DOMAIN:-$DEFAULTDOMAIN}
done
PASSAUTO="$(${PWGEN} -nc 14 -1)"
while [[ ! ${PASSWD} || -z "${PASSWD}" ]]; do
        read  -e -i "$PASSAUTO" -p "Password: " PASSWD
done

if [ $(${SASLDBLISTUSER} -f ${SASLDBFILE}| grep "^${USERNAME}@${DOMAIN}"| wc -l) -gt 0 ]; then
        echo "User ${USERNAME}@${DOMAIN} does already exist"
        echo 1
fi

log() {
        [ ! -d "$(dirname ${LOGFILE})" ] && mkdir $(dirname ${LOGFILE})
        echo -e "$(date +"%Y-%m-%d %T") Created user ${USERNAME}@${DOMAIN} with Password: ${PASSWD}" >> ${LOGFILE} &&\
        chmod 600 ${LOGFILE}
}

banner(){
        echo ""; echo "The new user credentials"; echo "------------------------"
        echo "Hostname: ${DOMAIN}"
        echo "Username: ${USERNAME}@${DOMAIN}"
        echo "Password: ${PASSWD}"
        echo "Protocol: Submission (Port 587), StartSSL mandatory"
}

echo ${PASSWD} | ${SASLDBPASSWD} -p -c -f ${SASLDBFILE} -u ${DOMAIN} ${USERNAME} && \
chmod 0660 ${SASLDBFILE} && \
chown root:sasl ${SASLDBFILE} && \
log && banner && \
[ "${SYNC}" = "1" ] && \
for HOST in ${HOSTS}; do
        ${RSYNC} --delete -aze 'ssh' ${SASLDBFILE} ${HOST}:${SASLDBFILE}
done