#!/bin/bash
# wget https://gist.githubusercontent.com/waja/cb6c427543b9dbea4c775ccfb1f308ab/raw/fix_cert_addtrust_external_expiration_apache.sh -O /tmp/a && bash /tmp/a && apache2ctl -t && service apache2 reload
TMPFILE=$(mktemp)
trap "{ rm -rf ${TMPFILE}; }" EXIT
for CERT in $(grep -P "^( |\t)*SSLCertificateFile" /etc/apache2/sites-enabled/* | awk '{print $3}'); do
	if [ \( "$(openssl x509 -in ${CERT} -issuer | head -1 | cut -d"=" -f7 | sed 's/^ *//g')" == "Sectigo RSA Domain Validation Secure Server CA" -o "$(openssl x509 -in ${CERT} -issuer | head -1 | cut -d"=" -f7 | sed 's/^ *//g')" == "COMODO RSA Domain Validation Secure Server CA" \) -a ! -L ${CERT} ]; then
		echo "${CERT}:"
		openssl crl2pkcs7 -nocrl -certfile ${CERT} | openssl pkcs7 -print_certs > ${TMPFILE}
		for CA in 'COMODO RSA Certification Authority' 'USERTrust RSA Certification Authority' 'AddTrust External CA Root'; do
			sed -i "/^subject.*${CA}/q" ${TMPFILE}
		done
		sed -Ei "/^(subject|issuer|$)/d" ${TMPFILE}
	cp -a ${CERT} ${CERT}.orig
	cp ${TMPFILE} ${CERT}
	fi
done
