#!/bin/sh
if [ "$(netstat -tapn | grep 'apache2' | awk {'print $7'} | sed 's#^[0-9]*/##' | tail -1 )" = "apache2" ]; then
  if ! [ -f /etc/apache2/conf.d/x_strong_cipherlist.conf ]; then
    cat <<EOF >> /etc/apache2/conf.d/x_strong_cipherlist.conf
<IfModule mod_ssl.c>
	SSLCipherSuite AES256+EECDH:AES256+EDH
	SSLProtocol All -SSLv2 -SSLv3
	SSLHonorCipherOrder On
	<IfVersion >= 2.4>
		SSLCompression off # Requires Apache >= 2.4
		SSLUseStapling on # Requires Apache >= 2.4
		SSLStaplingCache "shmcb:logs/stapling-cache(150000)" # Requires >= Apache 2.4
	</IfVersion>
</IfModule>
<IfModule mod_headers.c>
	Header always set Strict-Transport-Security "max-age=63072000; includeSubDomains"
	Header always set X-Frame-Options DENY
	Header always set X-Content-Type-Options nosniff
</IfModule>
EOF
    /etc/init.d/apache2 restart
  fi
fi
exit 0
# for checking that service
testssl.sh --poodle <vHost> | grep POODLE